@echo off
:: MySQL Automatic Backup Script
:: Configure these variables
set MYSQL_BIN="C:\xampp\mysql\bin\mysqldump.exe"
set MYSQL_USER=root
set MYSQL_PASSWORD=
set DATABASE_NAME=clinic3
set BACKUP_DIR=D:\backup
set DAYS_TO_KEEP=7

:: Create backup directory if it doesn't exist
if not exist "%BACKUP_DIR%" mkdir "%BACKUP_DIR%"

:: Set filename with timestamp
for /f "tokens=1-6 delims=/ " %%a in ('date /t') do (
    set year=%%c
    set month=%%a
    set day=%%b
)
for /f "tokens=1-3 delims=:." %%a in ('time /t') do (
    set hour=%%a
    set minute=%%b
)
set TIMESTAMP=%year%-%month%-%day%_%hour%-%minute%
set FILENAME=%BACKUP_DIR%\%DATABASE_NAME%_%TIMESTAMP%.sql

:: Perform the backup (with error logging)
echo Backing up %DATABASE_NAME% to %FILENAME%
%MYSQL_BIN% -u %MYSQL_USER% %DATABASE_NAME% > "%FILENAME%" 2> "%BACKUP_DIR%\mysql_error.log"

:: Check if backup succeeded
if %ERRORLEVEL% NEQ 0 (
    echo ERROR: MySQL dump failed. Check "%BACKUP_DIR%\mysql_error.log"
    exit /b 1
)

:: Delete old backups
forfiles /p "%BACKUP_DIR%" /m *.sql /d -%DAYS_TO_KEEP% /c "cmd /c del @path"

echo Backup completed successfully.