-- ============================================
-- SQL Queries to Clear Sale, Purchase, and Stock Records
-- ============================================
-- WARNING: These queries will DELETE ALL DATA from the specified tables
-- Make sure to backup your database before running these queries!
-- ============================================

-- ============================================
-- OPTION 1: Clear All Related Tables (Complete Cleanup)
-- ============================================
-- This option clears all related records including vouchers, movements, etc.

-- Disable foreign key checks temporarily
SET FOREIGN_KEY_CHECKS = 0;

-- Clear Sale Related Tables
DELETE FROM tbl_sale;
DELETE FROM tbl_sale_draft;
DELETE FROM tbl_sale_return;
DELETE FROM tbl_sale_return_item;
DELETE FROM tbl_sale_package;
DELETE FROM tbl_sale_package_no;
DELETE FROM tbl_sale_draft_no;
DELETE FROM tbl_sale_archive;
DELETE FROM tbl_patient_sale;
DELETE FROM tbl_inpatient_sale;

-- Clear Purchase Related Tables
DELETE FROM tbl_purchase;
DELETE FROM tbl_purchase_return;
DELETE FROM tbl_purchase_voucher;

-- Clear Stock Related Tables
DELETE FROM tbl_stock_movement;
DELETE FROM tbl_stock_transfer;
DELETE FROM tbl_stock_transfer_item;
DELETE FROM tbl_warehouse_stock;
DELETE FROM tbl_stock_expense;
DELETE FROM tbl_stock;

-- Clear Voucher Tables (if they reference sales/purchases)
DELETE FROM tbl_voucher;
DELETE FROM tbl_customer_debt;
DELETE FROM tbl_supplier_debt;

-- Clear Alert Table (stock alerts)
DELETE FROM tbl_alert;

-- Re-enable foreign key checks
SET FOREIGN_KEY_CHECKS = 1;

-- Reset Auto-Increment Counters
ALTER TABLE tbl_sale AUTO_INCREMENT = 1;
ALTER TABLE tbl_sale_draft AUTO_INCREMENT = 1;
ALTER TABLE tbl_sale_return AUTO_INCREMENT = 1;
ALTER TABLE tbl_sale_return_item AUTO_INCREMENT = 1;
ALTER TABLE tbl_sale_package AUTO_INCREMENT = 1;
ALTER TABLE tbl_sale_package_no AUTO_INCREMENT = 1;
ALTER TABLE tbl_sale_draft_no AUTO_INCREMENT = 1;
ALTER TABLE tbl_sale_archive AUTO_INCREMENT = 1;
ALTER TABLE tbl_patient_sale AUTO_INCREMENT = 1;
ALTER TABLE tbl_inpatient_sale AUTO_INCREMENT = 1;
ALTER TABLE tbl_purchase AUTO_INCREMENT = 1;
ALTER TABLE tbl_purchase_return AUTO_INCREMENT = 1;
ALTER TABLE tbl_purchase_voucher AUTO_INCREMENT = 1;
ALTER TABLE tbl_stock AUTO_INCREMENT = 1;
ALTER TABLE tbl_stock_movement AUTO_INCREMENT = 1;
ALTER TABLE tbl_stock_transfer AUTO_INCREMENT = 1;
ALTER TABLE tbl_stock_transfer_item AUTO_INCREMENT = 1;
ALTER TABLE tbl_warehouse_stock AUTO_INCREMENT = 1;
ALTER TABLE tbl_stock_expense AUTO_INCREMENT = 1;
ALTER TABLE tbl_voucher AUTO_INCREMENT = 1;
ALTER TABLE tbl_customer_debt AUTO_INCREMENT = 1;
ALTER TABLE tbl_supplier_debt AUTO_INCREMENT = 1;
ALTER TABLE tbl_alert AUTO_INCREMENT = 1;

-- ============================================
-- OPTION 2: Clear Only Main Tables (Preserve Related Data)
-- ============================================
-- Use this if you want to keep vouchers, debts, etc.

-- Clear Sales
DELETE FROM tbl_sale;
DELETE FROM tbl_sale_draft;
DELETE FROM tbl_patient_sale;
DELETE FROM tbl_inpatient_sale;

-- Clear Purchases
DELETE FROM tbl_purchase;
DELETE FROM tbl_purchase_return;

-- Clear Stock
DELETE FROM tbl_stock;
DELETE FROM tbl_warehouse_stock;
DELETE FROM tbl_stock_movement;
DELETE FROM tbl_stock_expense;

-- Reset Auto-Increment Counters
ALTER TABLE tbl_sale AUTO_INCREMENT = 1;
ALTER TABLE tbl_sale_draft AUTO_INCREMENT = 1;
ALTER TABLE tbl_patient_sale AUTO_INCREMENT = 1;
ALTER TABLE tbl_inpatient_sale AUTO_INCREMENT = 1;
ALTER TABLE tbl_purchase AUTO_INCREMENT = 1;
ALTER TABLE tbl_purchase_return AUTO_INCREMENT = 1;
ALTER TABLE tbl_stock AUTO_INCREMENT = 1;
ALTER TABLE tbl_warehouse_stock AUTO_INCREMENT = 1;
ALTER TABLE tbl_stock_movement AUTO_INCREMENT = 1;
ALTER TABLE tbl_stock_expense AUTO_INCREMENT = 1;

-- ============================================
-- OPTION 3: Clear Individual Tables (Selective)
-- ============================================

-- Clear Sales Only
DELETE FROM tbl_sale;
ALTER TABLE tbl_sale AUTO_INCREMENT = 1;

-- Clear Purchases Only
DELETE FROM tbl_purchase;
ALTER TABLE tbl_purchase AUTO_INCREMENT = 1;

-- Clear Stock Only
DELETE FROM tbl_stock;
DELETE FROM tbl_warehouse_stock;
DELETE FROM tbl_stock_movement;
ALTER TABLE tbl_stock AUTO_INCREMENT = 1;
ALTER TABLE tbl_warehouse_stock AUTO_INCREMENT = 1;
ALTER TABLE tbl_stock_movement AUTO_INCREMENT = 1;

-- ============================================
-- OPTION 4: Clear with Date Range (Selective Deletion)
-- ============================================
-- Use this to delete records within a specific date range

-- Clear sales before a specific date (e.g., before 2025-01-01)
DELETE FROM tbl_sale WHERE Date < '2025-01-01';
DELETE FROM tbl_purchase WHERE date < '2025-01-01';

-- Clear sales for a specific date range
-- DELETE FROM tbl_sale WHERE Date BETWEEN '2024-01-01' AND '2024-12-31';
-- DELETE FROM tbl_purchase WHERE date BETWEEN '2024-01-01' AND '2024-12-31';

-- ============================================
-- VERIFICATION QUERIES
-- ============================================
-- Run these after clearing to verify the data is gone

-- Check record counts
SELECT 'Sales' as TableName, COUNT(*) as RecordCount FROM tbl_sale
UNION ALL
SELECT 'Purchases', COUNT(*) FROM tbl_purchase
UNION ALL
SELECT 'Stock', COUNT(*) FROM tbl_stock
UNION ALL
SELECT 'Warehouse Stock', COUNT(*) FROM tbl_warehouse_stock
UNION ALL
SELECT 'Stock Movements', COUNT(*) FROM tbl_stock_movement
UNION ALL
SELECT 'Vouchers', COUNT(*) FROM tbl_voucher;

-- ============================================
-- BACKUP QUERY (Run BEFORE clearing)
-- ============================================
-- Create a backup of the data before clearing:

-- CREATE TABLE tbl_sale_backup AS SELECT * FROM tbl_sale;
-- CREATE TABLE tbl_purchase_backup AS SELECT * FROM tbl_purchase;
-- CREATE TABLE tbl_stock_backup AS SELECT * FROM tbl_stock;
-- CREATE TABLE tbl_warehouse_stock_backup AS SELECT * FROM tbl_warehouse_stock;

-- ============================================
-- NOTES:
-- ============================================
-- 1. Always backup your database before running DELETE queries
-- 2. SET FOREIGN_KEY_CHECKS = 0 allows deletion even with foreign key constraints
-- 3. Remember to SET FOREIGN_KEY_CHECKS = 1 after deletion
-- 4. Auto-increment reset ensures new records start from 1
-- 5. Consider using transactions for safety:
--    START TRANSACTION;
--    -- Your DELETE queries here
--    -- Check results
--    COMMIT; -- or ROLLBACK; if something went wrong
