# Database Configuration

## ⚠️ IMPORTANT: Single Source of Truth

**All database settings should be configured in `.env` file ONLY.**

This directory contains configuration files that are **auto-generated** or **read from environment variables**.

## Configuration Files

### `.env` (Primary Configuration)
**This is the ONLY place you should edit database settings.**

```env
DB_HOST=127.0.0.1
DB_PORT=3306
DB_USER=root
DB_PASSWORD=your_password
DB_NAME=clinic_pro_db_2
```

### `config.json` (Auto-Generated)
- **Purpose:** Used by Sequelize CLI for migrations
- **Source:** Generated from `.env` file
- **⚠️ Do NOT edit manually!**
- **To regenerate:** Run `node migrations/generate-config.js`

### `config.js` (Reads from .env)
- **Purpose:** Sequelize configuration for application code
- **Source:** Reads directly from `.env` via `process.env`
- **Status:** ✅ Already configured to use `.env`

### `database.js` (Reads from .env)
- **Purpose:** MySQL connection pool for application
- **Source:** Reads directly from `.env` via `process.env`
- **Status:** ✅ Already configured to use `.env`

## Quick Setup

1. **Configure `.env` file:**
   ```bash
   cp ENV_TEMPLATE.txt .env
   # Edit .env with your database settings
   ```

2. **Generate `config.json` (if using Sequelize CLI):**
   ```bash
   node migrations/generate-config.js
   ```

3. **That's it!** All other files automatically read from `.env`

## Files That Read from .env

✅ All these files automatically read from `.env`:
- `config/database.js`
- `config/config.js`
- `config/sequelize.js`
- `scripts/create-database.js`
- All migration and seeder scripts

## Summary

- ✅ **Edit:** `.env` file only
- ⚠️ **Auto-generated:** `config.json` (run generate script after changing .env)
- ✅ **Auto-read:** All other config files read from `.env`

