-- Create Patient Vitals Table for EMR
CREATE TABLE IF NOT EXISTS `tbl_patient_vitals` (
    `id` INT NOT NULL AUTO_INCREMENT,
    `patient_id` VARCHAR(50) NOT NULL,
    `treatment_id` INT NULL,
    `blood_pressure_systolic` INT NULL,
    `blood_pressure_diastolic` INT NULL,
    `heart_rate` INT NULL,
    `temperature` DECIMAL(4,1) NULL,
    `respiratory_rate` INT NULL,
    `oxygen_saturation` INT NULL,
    `weight` DECIMAL(5,2) NULL,
    `height` DECIMAL(5,2) NULL,
    `bmi` DECIMAL(4,2) NULL,
    `blood_glucose` DECIMAL(5,2) NULL,
    `recorded_by` VARCHAR(100) NULL,
    `recorded_date` DATETIME DEFAULT CURRENT_TIMESTAMP,
    `notes` TEXT NULL,
    PRIMARY KEY (`id`),
    INDEX `idx_patient_vitals` (`patient_id`),
    INDEX `idx_vitals_date` (`recorded_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

