/**
 * Fix Admin Password Script
 * Updates admin user password to 'admin' with proper bcrypt hash
 */

require('dotenv').config();
const bcrypt = require('bcryptjs');
const { query } = require('./config/database');

async function fixAdminPassword() {
    try {
        console.log('🔧 Fixing admin password...\n');

        // Generate hash for 'admin'
        const password = 'admin';
        const hashedPassword = await bcrypt.hash(password, 10);
        
        console.log('Generated hash:', hashedPassword);

        // Update admin user
        await query(
            'UPDATE tbl_user SET passwd = ? WHERE name = ?',
            [hashedPassword, 'admin']
        );

        console.log('\n✅ Admin password updated successfully!');
        console.log('\nYou can now login with:');
        console.log('  Username: admin');
        console.log('  Password: admin\n');

        // Verify it works
        const users = await query('SELECT * FROM tbl_user WHERE name = ?', ['admin']);
        if (users.length > 0) {
            const isMatch = await bcrypt.compare('admin', users[0].passwd);
            if (isMatch) {
                console.log('✅ Password verification: SUCCESS\n');
            } else {
                console.log('❌ Password verification: FAILED\n');
            }
        }

        process.exit(0);
    } catch (error) {
        console.error('❌ Error:', error.message);
        process.exit(1);
    }
}

fixAdminPassword();

