/**
 * i18next Middleware for Multi-language Support
 * Supports: English, Myanmar (Burmese), and Chinese
 */

const i18next = require('i18next');
const middleware = require('i18next-http-middleware');
const Backend = require('i18next-fs-backend');
const path = require('path');

i18next
    .use(Backend)
    .use(middleware.LanguageDetector)
    .init({
        backend: {
            loadPath: path.join(__dirname, '../locales/{{lng}}/{{ns}}.json')
        },
        fallbackLng: 'en',
        supportedLngs: ['en', 'my', 'zh'], // English, Myanmar, and Chinese
        defaultNS: 'translation',
        ns: ['translation'],
        detection: {
            order: ['querystring', 'cookie', 'header'],
            caches: ['cookie'],
            lookupQuerystring: 'lang',
            lookupCookie: 'i18next',
            lookupHeader: 'accept-language'
        },
        interpolation: {
            escapeValue: false
        }
    });

module.exports = middleware.handle(i18next);

