# Quick Start - Running the Migration

## The Problem
Sequelize CLI requires a `config.json` file, but this project uses `.env` for configuration.

## Solution Options

### ✅ Option 1: Use Standalone Script (RECOMMENDED - Easiest)

This script reads from `.env` automatically:

```bash
# From project root
node backend/migrations/run-create-all-tables.js
```

**Advantages:**
- ✅ Reads from `.env` automatically
- ✅ No configuration needed
- ✅ Works immediately

### Option 2: Update config.json with Your Credentials

Edit `backend/config/config.json` and update the database credentials:

```json
{
  "development": {
    "username": "your_db_user",
    "password": "your_db_password",
    "database": "clinic_pro_db",
    "host": "127.0.0.1",
    "port": 3306,
    "dialect": "mysql"
  }
}
```

Then run:
```bash
cd backend
npx sequelize-cli db:migrate
```

### Option 3: Generate config.json from .env

Run this script to generate `config.json` from your `.env`:

```bash
node backend/migrations/generate-config.js
```

Then run:
```bash
cd backend
npx sequelize-cli db:migrate
```

## Recommended: Use Option 1

The standalone script is the easiest and most reliable method.

