/**
 * Generate config.json from .env file
 * 
 * ⚠️ IMPORTANT: This file is auto-generated from .env file.
 * All database settings should be configured in .env file ONLY.
 * 
 * This script reads .env and creates config.json for Sequelize CLI compatibility.
 * Run this script whenever you change database settings in .env:
 *   node migrations/generate-config.js
 */

require('dotenv').config({ path: require('path').join(__dirname, '../.env') });
const fs = require('fs');
const path = require('path');

const configPath = path.join(__dirname, '../config/config.json');

const config = {
  development: {
    username: process.env.DB_USER || 'root',
    password: process.env.DB_PASSWORD || '',
    database: process.env.DB_NAME || 'clinic_pro_db',
    host: process.env.DB_HOST || '127.0.0.1',
    port: parseInt(process.env.DB_PORT) || 3306,
    dialect: 'mysql',
    logging: false,
    pool: {
      max: 5,
      min: 0,
      acquire: 30000,
      idle: 10000
    }
  },
  test: {
    username: process.env.DB_USER || 'root',
    password: process.env.DB_PASSWORD || '',
    database: process.env.DB_NAME ? `${process.env.DB_NAME}_test` : 'clinic_pro_db_test',
    host: process.env.DB_HOST || '127.0.0.1',
    port: parseInt(process.env.DB_PORT) || 3306,
    dialect: 'mysql',
    logging: false
  },
  production: {
    username: process.env.DB_USER || 'root',
    password: process.env.DB_PASSWORD || '',
    database: process.env.DB_NAME || 'clinic_pro_db',
    host: process.env.DB_HOST || '127.0.0.1',
    port: parseInt(process.env.DB_PORT) || 3306,
    dialect: 'mysql',
    logging: false,
    pool: {
      max: 10,
      min: 0,
      acquire: 30000,
      idle: 10000
    }
  }
};

try {
  fs.writeFileSync(configPath, JSON.stringify(config, null, 2));
  console.log('✅ Generated config.json from .env file');
  console.log(`   Location: ${configPath}`);
  console.log('\n📋 Configuration:');
  console.log(`   Database: ${config.development.database}`);
  console.log(`   Host: ${config.development.host}`);
  console.log(`   Port: ${config.development.port}`);
  console.log(`   User: ${config.development.username}`);
  console.log('\n✅ You can now run: npx sequelize-cli db:migrate');
} catch (error) {
  console.error('❌ Error generating config.json:', error.message);
  process.exit(1);
}

