/**
 * Models Index
 * Exports all model instances for all tables
 */

const BaseModel = require('./BaseModel');
const CustomerModel = require('./Customer.model');

// Create model instances for all tables
module.exports = {
    Alert: new BaseModel('tbl_alert'),
    Appointment: new BaseModel('tbl_appointment'),
    Case: new BaseModel('tbl_case'),
    Catalog: new BaseModel('tbl_catalog'),
    Catalog2: new BaseModel('tbl_catalog_2'),
    CatExpenses: new BaseModel('tbl_cat_expenses'),
    Customer: new CustomerModel(),
    CustomerDebt: new BaseModel('tbl_customer_debt'),
    Doctor: new BaseModel('tbl_doctor'),
    Expenses: new BaseModel('tbl_expenses'),
    Form: new BaseModel('tbl_form'),
    Images: new BaseModel('tbl_images'),
    Inpatient: new BaseModel('tbl_inpatient'),
    InpatientSale: new BaseModel('tbl_inpatient_sale'),
    InpatientSaleDebit: new BaseModel('tbl_inpatient_saledebit'),
    Labour: new BaseModel('tbl_labour'),
    LabourBalance: new BaseModel('tbl_labour_balance'),
    LabourLevel: new BaseModel('tbl_labour_level'),
    Loss: new BaseModel('tbl_loss'),
    Patient: new BaseModel('tbl_patient'),
    PatientSale: new BaseModel('tbl_patient_sale'),
    PaymentMethod: new BaseModel('tbl_payment_method'),
    Purchase: new BaseModel('tbl_purchase'),
    PurchaseReturn: new BaseModel('tbl_purchase_return'),
    PurchaseVoucher: new BaseModel('tbl_purchase_voucher'),
    Role: new BaseModel('tbl_role'),
    Sale: new BaseModel('tbl_sale'),
    SaleArchive: new BaseModel('tbl_sale_archive'),
    SaleDraft: new BaseModel('tbl_sale_draft'),
    SaleDraftNo: new BaseModel('tbl_sale_draft_no'),
    SalePackage: new BaseModel('tbl_sale_package'),
    SalePackageNo: new BaseModel('tbl_sale_package_no'),
    SaleReturn: new BaseModel('tbl_sale_return'),
    SaleReturnItem: new BaseModel('tbl_sale_return_item'),
    Service: new BaseModel('tbl_service'),
    ServiceCatalog: new BaseModel('tbl_service_catalog'),
    ShopInfo: new BaseModel('tbl_shopinfo'),
    Stock: new BaseModel('tbl_stock'),
    StockExpense: new BaseModel('tbl_stock_expense'),
    Supplier: new BaseModel('tbl_supplier'),
    SupplierDebt: new BaseModel('tbl_supplier_debt'),
    Treatment: new BaseModel('tbl_treatment'),
    Unit: new BaseModel('tbl_unit'),
    User: new BaseModel('tbl_user'),
    UserLog: new BaseModel('tbl_user_log'),
    Voucher: new BaseModel('tbl_voucher'),
    VoucherArchive: new BaseModel('tbl_voucher_archive'),
    VoucherReturn: new BaseModel('tbl_voucher_return')
};

