/**
 * Permission Model
 * Represents individual permissions as resource/action pairs
 */

const { DataTypes } = require('sequelize');
const { sequelize } = require('../../config/sequelize');

const Permission = sequelize.define('Permission', {
    id: {
        type: DataTypes.INTEGER,
        primaryKey: true,
        autoIncrement: true
    },
    resource: {
        type: DataTypes.STRING(100),
        allowNull: false,
        comment: 'Resource name (e.g., users, patients, sales, reports)'
    },
    action: {
        type: DataTypes.STRING(50),
        allowNull: false,
        comment: 'Action name (e.g., create, read, update, delete, manage)'
    },
    description: {
        type: DataTypes.TEXT,
        allowNull: true,
        comment: 'Permission description'
    },
    active: {
        type: DataTypes.BOOLEAN,
        allowNull: false,
        defaultValue: true,
        comment: 'Whether the permission is active'
    },
    metadata: {
        type: DataTypes.JSON,
        allowNull: true,
        defaultValue: {},
        comment: 'Additional metadata (e.g., category, scope, conditions)'
    }
}, {
    tableName: 'tbl_permission',
    timestamps: true,
    createdAt: 'created_at',
    updatedAt: 'updated_at',
    indexes: [
        {
            unique: true,
            fields: ['resource', 'action'],
            name: 'unique_resource_action'
        },
        {
            fields: ['resource']
        },
        {
            fields: ['action']
        },
        {
            fields: ['active']
        }
    ]
});

module.exports = Permission;

