/**
 * Role Model
 * Represents user roles with hierarchy levels
 */

const { DataTypes } = require('sequelize');
const { sequelize } = require('../../config/sequelize');

const Role = sequelize.define('Role', {
    id: {
        type: DataTypes.INTEGER,
        primaryKey: true,
        autoIncrement: true
    },
    name: {
        type: DataTypes.STRING(100),
        allowNull: false,
        unique: true,
        comment: 'Role name (e.g., Admin, Manager, Staff)'
    },
    level: {
        type: DataTypes.INTEGER,
        allowNull: false,
        defaultValue: 0,
        comment: 'Hierarchy level - higher number = higher authority (Admin=100, Manager=50, Staff=10)'
    },
    description: {
        type: DataTypes.TEXT,
        allowNull: true,
        comment: 'Role description'
    },
    active: {
        type: DataTypes.BOOLEAN,
        allowNull: false,
        defaultValue: true,
        comment: 'Whether the role is active'
    },
    metadata: {
        type: DataTypes.JSON,
        allowNull: true,
        defaultValue: {},
        comment: 'Additional metadata (e.g., color, icon, custom settings)'
    }
}, {
    tableName: 'tbl_role',
    timestamps: true,
    createdAt: 'created_at',
    updatedAt: 'updated_at',
    indexes: [
        {
            unique: true,
            fields: ['name']
        },
        {
            fields: ['level']
        },
        {
            fields: ['active']
        }
    ]
});

module.exports = Role;

