/**
 * RolePermission Model (Junction Table)
 * Links roles to permissions with additional metadata
 */

const { DataTypes } = require('sequelize');
const { sequelize } = require('../../config/sequelize');

const RolePermission = sequelize.define('RolePermission', {
    id: {
        type: DataTypes.INTEGER,
        primaryKey: true,
        autoIncrement: true
    },
    roleId: {
        type: DataTypes.INTEGER,
        allowNull: false,
        field: 'role_id',
        references: {
            model: 'tbl_role',
            key: 'id'
        },
        onDelete: 'CASCADE',
        comment: 'Foreign key to tbl_role'
    },
    permissionId: {
        type: DataTypes.INTEGER,
        allowNull: false,
        field: 'permission_id',
        references: {
            model: 'tbl_permission',
            key: 'id'
        },
        onDelete: 'CASCADE',
        comment: 'Foreign key to tbl_permission'
    },
    granted: {
        type: DataTypes.BOOLEAN,
        allowNull: false,
        defaultValue: true,
        comment: 'Whether permission is granted (true) or explicitly denied (false)'
    },
    active: {
        type: DataTypes.BOOLEAN,
        allowNull: false,
        defaultValue: true,
        comment: 'Whether this role-permission assignment is active'
    },
    metadata: {
        type: DataTypes.JSON,
        allowNull: true,
        defaultValue: {},
        comment: 'Additional metadata (e.g., conditions, scope, expiration)'
    }
}, {
    tableName: 'tbl_role_permission',
    timestamps: true,
    createdAt: 'created_at',
    updatedAt: 'updated_at',
    indexes: [
        {
            unique: true,
            fields: ['role_id', 'permission_id'],
            name: 'unique_role_permission'
        },
        {
            fields: ['role_id']
        },
        {
            fields: ['permission_id']
        },
        {
            fields: ['granted']
        },
        {
            fields: ['active']
        }
    ]
});

module.exports = RolePermission;

