/**
 * User Model (Sequelize)
 * Extends the existing tbl_user table with Sequelize associations
 */

const { DataTypes } = require('sequelize');
const { sequelize } = require('../../config/sequelize');

const User = sequelize.define('User', {
    id: {
        type: DataTypes.INTEGER,
        primaryKey: true,
        autoIncrement: true
    },
    roleId: {
        type: DataTypes.INTEGER,
        allowNull: false,
        field: 'role_id',
        references: {
            model: 'tbl_role',
            key: 'id'
        },
        comment: 'Foreign key to tbl_role'
    },
    name: {
        type: DataTypes.STRING(100),
        allowNull: true
    },
    passwd: {
        type: DataTypes.STRING(100),
        allowNull: true
    },
    phNo: {
        type: DataTypes.STRING(50),
        allowNull: true,
        field: 'ph_no'
    },
    nrcNo: {
        type: DataTypes.STRING(50),
        allowNull: true,
        field: 'nrc_no'
    },
    address: {
        type: DataTypes.STRING(150),
        allowNull: true
    },
    photo: {
        type: DataTypes.BLOB('long'),
        allowNull: true
    },
    date: {
        type: DataTypes.DATEONLY,
        allowNull: true
    }
}, {
    tableName: 'tbl_user',
    timestamps: false, // tbl_user doesn't have created_at/updated_at
    indexes: [
        {
            fields: ['role_id']
        }
    ]
});

module.exports = User;

