/**
 * Sequelize Models Index
 * Initializes all models and their associations
 */

const { sequelize } = require('../../config/sequelize');
const Role = require('./Role');
const Permission = require('./Permission');
const RolePermission = require('./RolePermission');
const User = require('./User');

// Define associations

// Role <-> Permission (Many-to-Many through RolePermission)
Role.belongsToMany(Permission, {
    through: RolePermission,
    foreignKey: 'role_id',
    otherKey: 'permission_id',
    as: 'permissions'
});

Permission.belongsToMany(Role, {
    through: RolePermission,
    foreignKey: 'permission_id',
    otherKey: 'role_id',
    as: 'roles'
});

// RolePermission associations
RolePermission.belongsTo(Role, {
    foreignKey: 'role_id',
    as: 'role'
});

RolePermission.belongsTo(Permission, {
    foreignKey: 'permission_id',
    as: 'permission'
});

// User -> Role (Many-to-One)
User.belongsTo(Role, {
    foreignKey: 'role_id',
    as: 'role'
});

Role.hasMany(User, {
    foreignKey: 'role_id',
    as: 'users'
});

module.exports = {
    sequelize,
    Role,
    Permission,
    RolePermission,
    User
};

