"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var utils = _interopRequireWildcard(require("./utils.js"));
var _cookie = _interopRequireDefault(require("./languageLookups/cookie.js"));
var _querystring = _interopRequireDefault(require("./languageLookups/querystring.js"));
var _path = _interopRequireDefault(require("./languageLookups/path.js"));
var _header = _interopRequireDefault(require("./languageLookups/header.js"));
var _session = _interopRequireDefault(require("./languageLookups/session.js"));
var _httpFunctions = require("./httpFunctions.js");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function getDefaults() {
  return (0, _httpFunctions.extendOptionsWithDefaults)({
    order: ['querystring', 'cookie', 'header'],
    lookupQuerystring: 'lng',
    lookupCookie: 'i18next',
    lookupSession: 'lng',
    lookupFromPathIndex: 0,
    caches: false,
    cookieSameSite: 'strict',
    ignoreCase: true,
    convertDetectedLanguage: function convertDetectedLanguage(l) {
      return l;
    }
  });
}
function getFallbackLngs(fallbackLng) {
  var fallbacks = fallbackLng;
  if (typeof fallbacks === 'function') fallbacks = fallbacks();
  if (typeof fallbacks === 'string') fallbacks = [fallbacks];
  if (!fallbacks) fallbacks = [];
  return fallbacks;
}
var LanguageDetector = function () {
  function LanguageDetector(services) {
    var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
    var allOptions = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
    _classCallCheck(this, LanguageDetector);
    this.type = 'languageDetector';
    this.detectors = {};
    this.init(services, options, allOptions);
  }
  return _createClass(LanguageDetector, [{
    key: "init",
    value: function init(services) {
      var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var allOptions = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
      this.services = services;
      this.options = utils.defaults(options, this.options || {}, getDefaults());
      this.allOptions = allOptions;
      if (typeof this.options.convertDetectedLanguage === 'string' && this.options.convertDetectedLanguage.indexOf('15897') > -1) {
        this.options.convertDetectedLanguage = function (l) {
          return l.replace('-', '_');
        };
      }
      this.addDetector(_cookie.default);
      this.addDetector(_querystring.default);
      this.addDetector(_path.default);
      this.addDetector(_header.default);
      this.addDetector(_session.default);
      this.fallbacks = getFallbackLngs(this.allOptions.fallbackLng);
    }
  }, {
    key: "addDetector",
    value: function addDetector(detector) {
      this.detectors[detector.name] = detector;
    }
  }, {
    key: "detect",
    value: function detect(req, res, detectionOrder) {
      var _this = this;
      if (arguments.length < 2) return;
      if (!detectionOrder) detectionOrder = this.options.order;
      var found;
      detectionOrder.forEach(function (detectorName) {
        if (found || !_this.detectors[detectorName]) return;
        var detections = _this.detectors[detectorName].lookup(req, res, _this.options);
        if (!detections) return;
        if (!Array.isArray(detections)) detections = [detections];
        detections = detections.filter(function (d) {
          return d !== undefined && d !== null && !utils.hasXSS(d);
        }).map(function (d) {
          return _this.options.convertDetectedLanguage(d);
        });
        if (_this.services.languageUtils.getBestMatchFromCodes) {
          found = _this.services.languageUtils.getBestMatchFromCodes(detections);
          if (found) {
            if (_this.options.ignoreCase) {
              if (detections.length === 0 || detections.map(function (d) {
                return d.toLowerCase();
              }).indexOf(found.toLowerCase()) < 0 && _this.fallbacks.map(function (d) {
                return d.toLowerCase();
              }).indexOf(found.toLowerCase()) > -1) found = undefined;
            } else {
              if (detections.length === 0 || detections.indexOf(found) < 0 && _this.fallbacks.indexOf(found) > -1) found = undefined;
            }
          }
          if (found) req.i18nextLookupName = detectorName;
        } else {
          found = detections.length > 0 ? detections[0] : null;
        }
      });
      if (!found) {
        var fallbacks = this.fallbacks;
        if (Object.prototype.toString.apply(fallbacks) === '[object Array]') {
          found = fallbacks[0];
        } else {
          found = fallbacks[0] || fallbacks.default && fallbacks.default[0];
        }
      }
      ;
      return found;
    }
  }, {
    key: "cacheUserLanguage",
    value: function cacheUserLanguage(req, res, lng, caches) {
      var _this2 = this;
      if (arguments.length < 3) return;
      if (!caches) caches = this.options.caches;
      if (!caches) return;
      caches.forEach(function (cacheName) {
        if (_this2.detectors[cacheName] && _this2.detectors[cacheName].cacheUserLanguage && res.cachedUserLanguage !== lng) {
          _this2.detectors[cacheName].cacheUserLanguage(req, res, lng, _this2.options);
          res.cachedUserLanguage = lng;
        }
      });
    }
  }]);
}();
LanguageDetector.type = 'languageDetector';
var _default = exports.default = LanguageDetector;
module.exports = exports.default;