/**
 * Enhanced Analytics & Reporting Routes
 * Quality Metrics, Clinical Indicators, Hospital KPIs
 */

const express = require('express');
const router = express.Router();
const { protect } = require('../middleware/auth');
const { requireCrudPermission } = require('../middleware/permissions');
const {
    getQualityMetrics,
    addQualityMetric,
    getClinicalIndicators,
    getInfectionSurveillance,
    reportInfection,
    getReadmissions,
    getPatientSatisfaction,
    getOperationalMetrics,
    getIncidentReports,
    reportIncident,
    getDashboardStats
} = require('../controllers/analytics.controller');

router.use(protect);
router.use(requireCrudPermission('reports'));

// Dashboard
router.get('/dashboard', getDashboardStats);

// Quality Metrics
router.get('/quality-metrics', getQualityMetrics);
router.post('/quality-metrics', addQualityMetric);

// Clinical Indicators
router.get('/clinical-indicators', getClinicalIndicators);

// Infection Surveillance
router.get('/infections', getInfectionSurveillance);
router.post('/infections', reportInfection);

// Readmissions
router.get('/readmissions', getReadmissions);

// Patient Satisfaction
router.get('/patient-satisfaction', getPatientSatisfaction);

// Operational Metrics
router.get('/operational-metrics', getOperationalMetrics);

// Incident Reports
router.get('/incidents', getIncidentReports);
router.post('/incidents', reportIncident);

module.exports = router;

