const express = require('express');
const router = express.Router();
const { protect } = require('../middleware/auth');
const { backupUpload } = require('../middleware/upload');
const {
    createBackup,
    getBackups,
    downloadBackup,
    restoreBackup,
    deleteBackup,
    uploadBackup
} = require('../controllers/backup.controller');

router.use(protect);

router.post('/create', createBackup);
router.get('/list', getBackups);
router.get('/download/:filename', downloadBackup);
router.post('/restore', restoreBackup);
router.delete('/:filename', deleteBackup);
router.post('/upload', backupUpload.single('backup'), uploadBackup);

module.exports = router;

