const express = require('express');
const router = express.Router();
const { protect } = require('../middleware/auth');
const {
    getDeposits,
    getDeposit,
    getPatientDeposits,
    createDeposit,
    updateDeposit,
    cancelDeposit,
    getDepositStats
} = require('../controllers/deposit.controller');

// Protect all routes
router.use(protect);

// Deposit routes
router.route('/')
    .get(getDeposits)
    .post(createDeposit);

router.route('/stats')
    .get(getDepositStats);

router.route('/patient/:patient_id')
    .get(getPatientDeposits);

router.route('/:id')
    .get(getDeposit)
    .put(updateDeposit)
    .delete(cancelDeposit);

module.exports = router;
