/**
 * Discharged Patient Report Routes
 */

const express = require('express');
const router = express.Router();
const {
    getDischargedPatientReport,
    getDischargedPatients
} = require('../controllers/discharged-patient-report.controller');
const { protect } = require('../middleware/auth');

// Apply authentication middleware to all routes
router.use(protect);

// @route   GET /api/reports/discharged-patients
// @desc    Get list of discharged patients
// @access  Private
router.get('/discharged-patients', getDischargedPatients);

// @route   GET /api/reports/discharged-patient/:patientId
// @desc    Get comprehensive discharged patient report
// @access  Private
router.get('/discharged-patient/:patientId', getDischargedPatientReport);

module.exports = router;
