const express = require('express');
const router = express.Router();
const { protect } = require('../middleware/auth');
const { requireCrudPermission } = require('../middleware/permissions');
const { upload } = require('../middleware/upload');
const {
    getDoctors,
    getDoctor,
    createDoctor,
    updateDoctor,
    deleteDoctor
} = require('../controllers/doctor.controller');

router.use(protect);
router.use(requireCrudPermission('doctors'));

router.route('/')
    .get(getDoctors)
    .post(upload.single('photo'), createDoctor);

router.route('/:id')
    .get(getDoctor)
    .put(upload.single('photo'), updateDoctor)
    .delete(deleteDoctor);

module.exports = router;

