/**
 * EMR (Electronic Medical Records) Routes
 */

const express = require('express');
const router = express.Router();
const { protect } = require('../middleware/auth');
const { requireCrudPermission } = require('../middleware/permissions');
const { uploadMultiple } = require('../middleware/upload');
const {
    getPatientHistory,
    getTreatment,
    createTreatment,
    updateTreatment,
    deleteTreatment,
    deleteImage,
    getVitalsHistory,
    getVitalsChartFromEMR,
    searchTreatments,
    getStats,
    getAllTreatments
} = require('../controllers/emr.controller');

router.use(protect);
router.use(requireCrudPermission('emr'));

router.get('/stats', getStats);
router.get('/search', searchTreatments);
router.get('/all-treatments', getAllTreatments);
router.get('/patient/:patientId/history', getPatientHistory);
router.get('/patient/:patientId/vitals', getVitalsHistory);
router.get('/patient/:patientId/vitals/chart', getVitalsChartFromEMR);
router.get('/treatment/:id', getTreatment);

router.post('/treatment', uploadMultiple, createTreatment);
router.put('/treatment/:id', uploadMultiple, updateTreatment);
router.delete('/treatment/:id', deleteTreatment);
router.delete('/image/:id', deleteImage);

module.exports = router;

