const express = require('express');
const router = express.Router();
const { protect } = require('../middleware/auth');
const { requireCrudPermission } = require('../middleware/permissions');
const {
    createExpense,
    getExpenses,
    getExpenseById,
    updateExpense,
    deleteExpense,
    getExpenseStats,
    getExpensesByDateRange,
    getExpenseCategories,
    createExpenseCategory,
    updateExpenseCategory,
    deleteExpenseCategory
} = require('../controllers/expense.controller');

// Apply authentication middleware to all routes
router.use(protect);
router.use(requireCrudPermission('expenses'));

// Expense categories
router.get('/categories', getExpenseCategories);
router.post('/categories', createExpenseCategory);
router.put('/categories/:id', updateExpenseCategory);
router.delete('/categories/:id', deleteExpenseCategory);

// GET /api/expenses/stats - Get expense statistics
router.get('/stats', getExpenseStats);

// GET /api/expenses/date-range - Get expenses by date range
router.get('/date-range', getExpensesByDateRange);

// GET /api/expenses - Get all expenses
router.get('/', getExpenses);

// POST /api/expenses - Create new expense
router.post('/', createExpense);

// GET /api/expenses/:id - Get expense by ID
router.get('/:id', getExpenseById);

// PUT /api/expenses/:id - Update expense
router.put('/:id', updateExpense);

// DELETE /api/expenses/:id - Delete expense
router.delete('/:id', deleteExpense);

module.exports = router;

