const express = require('express');
const router = express.Router();
const { protect } = require('../middleware/auth');
const {
    getInpatientDeposits,
    addInpatientDeposit,
    withdrawInpatientDeposit,
    getInpatientDepositSummary
} = require('../controllers/inpatient-deposit.controller');

// Protect all routes
router.use(protect);

// Inpatient deposit routes
router.get('/:inpatientId', getInpatientDeposits);
router.get('/:inpatientId/summary', getInpatientDepositSummary);
router.post('/', addInpatientDeposit);
router.post('/withdraw', withdrawInpatientDeposit);

module.exports = router;
