const express = require('express');
const router = express.Router();
const { protect } = require('../middleware/auth');
const {
    getInpatientReport,
    getInpatientsForReport
} = require('../controllers/inpatient-report.controller');

// Protect all routes
router.use(protect);

// Inpatient report routes
router.get('/inpatient/:inpatientId', getInpatientReport);
router.get('/inpatients', getInpatientsForReport);

module.exports = router;
