/**
 * Inpatient Sales Routes
 * Handles daily usage tracking, deposits, and discharge settlements
 */

const express = require('express');
const router = express.Router();
const {
    getDailyUsage,
    addDailyUsage,
    updateUsage,
    deleteUsage,
    collectDeposit,
    getOutstandingBalance,
    settleDischarge,
    getDischargeReport
} = require('../controllers/inpatient-sales.controller');
const { protect } = require('../middleware/auth');

// Apply authentication middleware to all routes
router.use(protect);

// Daily usage routes
router.get('/usage/:inpatientId', getDailyUsage);
router.post('/usage', addDailyUsage);
router.put('/usage/:id', updateUsage);
router.delete('/usage/:id', deleteUsage);

// Deposit routes
router.post('/deposit', collectDeposit);

// Balance and settlement routes
router.get('/outstanding/:inpatientId', getOutstandingBalance);
router.post('/discharge', settleDischarge);
router.get('/discharge-report/:inpatientId', getDischargeReport);

module.exports = router;
