const express = require('express');
const router = express.Router();
const { protect } = require('../middleware/auth');
const { requireCrudPermission } = require('../middleware/permissions');
const inpatientController = require('../controllers/inpatient.controller');

// Use protection middleware
router.use(protect);
router.use(requireCrudPermission('inpatients'));

// Define routes
router.route('/')
    .get(inpatientController.getAllInpatients)
    .post(inpatientController.createInpatient);

router.route('/:id')
    .get(inpatientController.getInpatient)
    .put(inpatientController.updateInpatient)
    .delete(inpatientController.dischargeInpatient);

// Additional routes for bed management
router.get('/available-beds', inpatientController.getAvailableBeds);
router.patch('/beds/:bedId/clean', inpatientController.cleanBed);

module.exports = router;