const express = require('express');
const router = express.Router();
const invoiceController = require('../controllers/invoice.controller');
const { protect } = require('../middleware/auth');

// Apply authentication middleware to all routes
router.use(protect);

/**
 * @route   GET /api/invoice/:voucherNo
 * @desc    Get invoice data for a specific voucher
 * @access  Private
 */
router.get('/:voucherNo', invoiceController.getInvoiceData);

/**
 * @route   POST /api/invoice/generate
 * @desc    Generate invoice data for printing
 * @access  Private
 */
router.post('/generate', invoiceController.generateInvoice);

module.exports = router;
