/**
 * Laboratory Routes
 * Professional lab management system
 */

const express = require('express');
const router = express.Router();
const { protect } = require('../middleware/auth');
const {
    getLabCatalog,
    getLabCategories,
    createLabOrder,
    getLabOrders,
    getLabOrder,
    collectSpecimen,
    enterLabResult,
    getPatientResults,
    verifyLabResult,
    getCriticalAlerts,
    acknowledgeAlert,
    getLabStats,
    addTestToCatalog,
    updateTestInCatalog,
    deleteTestFromCatalog
} = require('../controllers/laboratory.controller');

router.use(protect);

// Lab test catalog
router.get('/catalog', getLabCatalog);
router.post('/catalog', addTestToCatalog);
router.put('/catalog/:id', updateTestInCatalog);
router.delete('/catalog/:id', deleteTestFromCatalog);
router.get('/categories', getLabCategories);

// Lab orders
router.post('/orders', createLabOrder);
router.get('/orders', getLabOrders);
router.get('/orders/:id', getLabOrder);
router.patch('/orders/:id/collect', collectSpecimen);

// Lab results
router.post('/results', enterLabResult);
router.get('/results/patient/:patientId', getPatientResults);
router.patch('/results/:id/verify', verifyLabResult);

// Critical alerts
router.get('/alerts', getCriticalAlerts);
router.patch('/alerts/:id/acknowledge', acknowledgeAlert);

// Statistics
router.get('/stats', getLabStats);

module.exports = router;

