const express = require('express');
const router = express.Router();
const { protect } = require('../middleware/auth');
const {
    getNotifications,
    getNotificationCounts,
    getStockAlerts,
    getExpirationAlerts,
    markAsRead,
    markAllAsRead
} = require('../controllers/notification.controller');

router.use(protect);

router.get('/', getNotifications);
router.get('/counts', getNotificationCounts);
router.get('/stock-alerts', getStockAlerts);
router.get('/expiration-alerts', getExpirationAlerts);
router.put('/:notificationId/read', markAsRead);
router.put('/mark-all-read', markAllAsRead);

module.exports = router;

