const express = require('express');
const router = express.Router();
const { protect } = require('../middleware/auth');
const { requireCrudPermission } = require('../middleware/permissions');
const {
    getPatients,
    getPatient,
    createPatient,
    updatePatient,
    deletePatient,
    searchPatients,
    getPatientHistory,
    checkPatientExists
} = require('../controllers/patient.controller');

router.use(protect);
router.use(requireCrudPermission('patients'));

router.route('/')
    .get(getPatients)
    .post(createPatient);

router.route('/search')
    .get(searchPatients);

router.route('/check')
    .get(checkPatientExists);

router.route('/:id')
    .get(getPatient)
    .put(updatePatient)
    .delete(deletePatient);

router.route('/:id/history')
    .get(getPatientHistory);

module.exports = router;

