/**
 * Permission Management Routes
 */

const express = require('express');
const router = express.Router();
const { protect } = require('../middleware/auth');
const { requirePermission } = require('../middleware/permissions');
const {
    getRoles,
    getRole,
    createRole,
    updateRole,
    getPermissions,
    createPermission,
    getRolePermissions,
    updateRolePermissions,
    getUsers,
    updateUserRole,
    getUserPermissions
} = require('../controllers/permission.controller');

// All routes require authentication and admin permissions
router.use(protect);
router.use(requirePermission('settings', 'manage'));

// Role routes
router.get('/roles', getRoles);
router.get('/roles/:id', getRole);
router.post('/roles', createRole);
router.put('/roles/:id', updateRole);

// Permission routes
router.get('/permissions', getPermissions);
router.post('/permissions', createPermission);

// Role-Permission assignment routes
router.get('/roles/:roleId/permissions', getRolePermissions);
router.put('/roles/:roleId/permissions', updateRolePermissions);

// User role management routes
router.get('/users', getUsers);
router.put('/users/:userId/role', updateUserRole);
router.get('/users/:userId/permissions', getUserPermissions);

module.exports = router;

