/**
 * Point of Sale Routes
 */

const express = require('express');
const router = express.Router();
const { protect } = require('../middleware/auth');
const {
    getProducts,
    getServices,
    getItems,
    getCategories,
    getNextVoucher,
    processSale,
    saveDraft,
    getDrafts,
    getDraft,
    deleteDraft,
    getPaymentMethods,
    getVoucherDetails
} = require('../controllers/pos.controller');

router.use(protect);

router.get('/products', getProducts);
router.get('/services', getServices);
router.get('/items', getItems);
router.get('/categories', getCategories);
router.get('/next-voucher', getNextVoucher);
router.get('/payment-methods', getPaymentMethods);
router.get('/voucher/:vno', getVoucherDetails);
router.get('/drafts', getDrafts);
router.get('/draft/:id', getDraft);
router.post('/sale', processSale);
router.post('/draft', saveDraft);
router.delete('/draft/:id', deleteDraft);

module.exports = router;

