/**
 * Product Routes
 */

const express = require('express');
const router = express.Router();
const { protect } = require('../middleware/auth');
const { requireCrudPermission } = require('../middleware/permissions');
const { uploadSingle } = require('../middleware/upload');
const {
    getProducts,
    getProduct,
    createProduct,
    updateProduct,
    deleteProduct,
    generateBarcode,
    updateStock,
    getProductWarehouseStock
} = require('../controllers/product.controller');

router.use(protect);
// Enforce CRUD permissions for stock/products
router.use(requireCrudPermission('stock'));

router.route('/')
    .get(getProducts)
    .post(uploadSingle, createProduct);

router.get('/generate-barcode', generateBarcode);

// Warehouse stock route - must be before /:id route
router.get('/:id/warehouse-stock', getProductWarehouseStock);

router.route('/:id')
    .get(getProduct)
    .put(uploadSingle, updateProduct)
    .delete(deleteProduct);

router.put('/:id/stock', updateStock);

module.exports = router;

