// Referring Doctor Routes
const express = require('express');
const router = express.Router();
const referringDoctorController = require('../controllers/referring-doctor.controller');
const commissionController = require('../controllers/commission.controller');
const { protect } = require('../middleware/auth');

// Apply authentication to all routes
router.use(protect);

// ============================================
// COMMISSION ROUTES (Must come before /:id routes)
// ============================================

// Get all commissions
router.get('/commissions/list', commissionController.getAllCommissions);

// Get commission statistics
router.get('/commissions/stats', commissionController.getCommissionStats);

// Get single commission
router.get('/commissions/:id', commissionController.getCommissionById);

// Create commission (manual)
router.post('/commissions', commissionController.createCommission);

// Approve commission
router.patch('/commissions/:id/approve', commissionController.approveCommission);

// Mark commission as paid
router.patch('/commissions/:id/pay', commissionController.payCommission);

// Batch pay commissions
router.post('/commissions/batch-pay', commissionController.batchPayCommissions);

// Cancel commission
router.patch('/commissions/:id/cancel', commissionController.cancelCommission);

// ============================================
// REFERRING DOCTOR ROUTES
// ============================================

// Get all referring doctors
router.get('/', referringDoctorController.getAllReferringDoctors);

// Get commission summary (overview)
router.get('/summary', referringDoctorController.getCommissionSummary);

// Get single referring doctor
router.get('/:id', referringDoctorController.getReferringDoctorById);

// Get referring doctor statistics
router.get('/:id/stats', referringDoctorController.getReferringDoctorStats);

// Create new referring doctor
router.post('/', referringDoctorController.createReferringDoctor);

// Update referring doctor
router.put('/:id', referringDoctorController.updateReferringDoctor);

// Delete referring doctor
router.delete('/:id', referringDoctorController.deleteReferringDoctor);

module.exports = router;

