const express = require('express');
const router = express.Router();
const { protect } = require('../middleware/auth');
const { requireCrudPermission } = require('../middleware/permissions');
const {
    getSuppliers,
    getSupplier,
    createSupplier,
    updateSupplier,
    deleteSupplier,
    getSupplierStock
} = require('../controllers/supplier.controller');

router.use(protect);
router.use(requireCrudPermission('suppliers'));

router.route('/')
    .get(getSuppliers)
    .post(createSupplier);

// Must be before /:id route
router.route('/:id/stock')
    .get(getSupplierStock);

router.route('/:id')
    .get(getSupplier)
    .put(updateSupplier)
    .delete(deleteSupplier);

module.exports = router;
