const express = require('express');
const router = express.Router();
const { protect } = require('../middleware/auth');
const {
    getUsers,
    getUser,
    createUser,
    updateUser,
    deleteUser,
    changePassword,
    getRoles,
    getUserStats
} = require('../controllers/user.controller');

router.use(protect);

router.get('/stats', getUserStats);
router.get('/roles', getRoles);
router.post('/change-password', changePassword);

router.route('/')
    .get(getUsers)
    .post(createUser);

router.route('/:id')
    .get(getUser)
    .put(updateUser)
    .delete(deleteUser);

module.exports = router;

