/**
 * Script to add flag-icon-css library to all HTML pages
 */

const fs = require('fs');
const path = require('path');

const pagesDir = path.join(__dirname, '../../frontend/pages');
const flagIconLink = '<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/flag-icon-css/6.6.6/css/flag-icons.min.css">';
const flagIconLinkRelative = '<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/flag-icon-css/6.6.6/css/flag-icons.min.css">';

function addFlagIconsToPage(filePath) {
    try {
        let content = fs.readFileSync(filePath, 'utf8');
        const fileName = path.basename(filePath);
        
        // Skip if already has flag-icons
        if (content.includes('flag-icon-css') || content.includes('flag-icons')) {
            console.log(`✓ ${fileName} already has flag-icons`);
            return;
        }
        
        // Find bootstrap-icons link and add flag-icons after it
        const bootstrapIconsPattern = /<link[^>]*bootstrap-icons[^>]*>/i;
        if (content.match(bootstrapIconsPattern)) {
            content = content.replace(bootstrapIconsPattern, `$&\n    ${flagIconLink}`);
            fs.writeFileSync(filePath, content, 'utf8');
            console.log(`✓ Added flag-icons to ${fileName}`);
        } else {
            // Try to find any stylesheet link
            const stylesheetPattern = /<link[^>]*stylesheet[^>]*>/i;
            const matches = content.match(stylesheetPattern);
            if (matches) {
                // Add after last stylesheet
                const lastMatch = matches[matches.length - 1];
                const lastIndex = content.lastIndexOf(lastMatch);
                const insertIndex = lastIndex + lastMatch.length;
                content = content.slice(0, insertIndex) + '\n    ' + flagIconLink + content.slice(insertIndex);
                fs.writeFileSync(filePath, content, 'utf8');
                console.log(`✓ Added flag-icons to ${fileName} (after last stylesheet)`);
            } else {
                console.log(`⚠ Could not find insertion point in ${fileName}`);
            }
        }
    } catch (error) {
        console.error(`✗ Error processing ${filePath}:`, error.message);
    }
}

// Get all HTML files
const files = fs.readdirSync(pagesDir).filter(file => file.endsWith('.html'));

console.log(`Found ${files.length} HTML files in frontend/pages\n`);

files.forEach(file => {
    const filePath = path.join(pagesDir, file);
    addFlagIconsToPage(filePath);
});

console.log('\n✓ Done! All pages should now have flag-icons library');

