/**
 * Seeder: Default Roles
 * Seeds default roles (Admin, Manager, Staff) with hierarchy levels
 */

'use strict';

module.exports = {
    async up(queryInterface, Sequelize) {
        // Define default roles
        const roles = [
            {
                id: 1,
                name: 'Admin',
                level: 100,
                description: 'Full system access with all permissions',
                active: true,
                metadata: JSON.stringify({ color: '#dc3545', icon: 'shield', bypassChecks: true }),
                created_at: new Date(),
                updated_at: new Date()
            },
            {
                id: 2,
                name: 'Manager',
                level: 50,
                description: 'Management access with most permissions except system administration',
                active: true,
                metadata: JSON.stringify({ color: '#ffc107', icon: 'briefcase' }),
                created_at: new Date(),
                updated_at: new Date()
            },
            {
                id: 3,
                name: 'Staff',
                level: 10,
                description: 'Standard staff access with limited permissions',
                active: true,
                metadata: JSON.stringify({ color: '#17a2b8', icon: 'user' }),
                created_at: new Date(),
                updated_at: new Date()
            }
        ];

        // Insert or update roles
        for (const role of roles) {
            const [existing] = await queryInterface.sequelize.query(
                `SELECT id FROM tbl_role WHERE id = ${role.id}`
            );

            if (existing.length > 0) {
                await queryInterface.bulkUpdate('tbl_role', {
                    name: role.name,
                    level: role.level,
                    description: role.description,
                    active: role.active,
                    metadata: role.metadata,
                    updated_at: role.updated_at
                }, { id: role.id });
            } else {
                await queryInterface.bulkInsert('tbl_role', [role]);
            }
        }
    },

    async down(queryInterface, Sequelize) {
        // Remove default roles (be careful - only if no users reference them)
        await queryInterface.bulkDelete('tbl_role', {
            id: [1, 2, 3]
        });
    }
};

