/**
 * Seeder: Default Permissions
 * Seeds common permissions for clinic management system
 */

'use strict';

module.exports = {
    async up(queryInterface, Sequelize) {
        // Define common resources and actions
        const resources = [
            'users', 'patients', 'doctors', 'appointments', 'sales', 'purchases',
            'stock', 'reports', 'settings', 'dashboard', 'emr', 'inpatients',
            'laboratory', 'pharmacy', 'warehouse', 'expenses', 'suppliers', 'stockExpense'
        ];

        const actions = ['create', 'read', 'update', 'delete', 'export'];

        // Generate permissions
        const permissions = [];
        let id = 1;

        for (const resource of resources) {
            for (const action of actions) {
                permissions.push({
                    id: id++,
                    resource,
                    action,
                    description: `${action.charAt(0).toUpperCase() + action.slice(1)} ${resource}`,
                    active: true,
                    metadata: JSON.stringify({ category: resource }),
                    created_at: new Date(),
                    updated_at: new Date()
                });
            }
        }

        // Insert permissions (ignore duplicates)
        for (const permission of permissions) {
            const [existing] = await queryInterface.sequelize.query(
                `SELECT id FROM tbl_permission WHERE resource = '${permission.resource}' AND action = '${permission.action}'`
            );

            if (existing.length === 0) {
                await queryInterface.bulkInsert('tbl_permission', [permission]);
            }
        }
    },

    async down(queryInterface, Sequelize) {
        await queryInterface.bulkDelete('tbl_permission', null, {});
    }
};

