# Seeders - Users and Permissions

This directory contains seeders for populating the database with initial users, roles, and permissions based on the `clinic_pro_db.sql` dump file.

## Available Seeders

### 1. `005-seed-from-sql-dump.js` (RECOMMENDED)
- **Purpose:** Extracts and seeds data directly from `clinic_pro_db.sql`
- **Data:** Users, Roles, Permissions, Role-Permissions
- **Source:** Reads INSERT statements from the SQL dump file
- **Idempotent:** Safe to run multiple times

### 2. `004-seed-users-and-permissions-from-dump.js`
- **Purpose:** Programmatically creates users, roles, and permissions
- **Data:** Matches dump file structure
- **Use Case:** If SQL extraction has issues

### 3. `001-seed-default-roles.js`
- **Purpose:** Seeds basic roles (Admin, Manager, Staff)
- **Note:** Only 3 roles, not all 5 from dump

### 4. `002-seed-default-permissions.js`
- **Purpose:** Generates permissions programmatically
- **Note:** May not match exact dump file permissions

### 5. `003-seed-role-permissions.js`
- **Purpose:** Assigns permissions to roles
- **Note:** Uses generated permissions, not dump file mappings

## Quick Start

### Option 1: Using Standalone Script (Easiest)

```bash
# From project root
node backend/seeders/run-seed-users-permissions.js
```

### Option 2: Using Sequelize CLI

```bash
# From backend directory
npx sequelize-cli db:seed:all
# Or seed specific file
npx sequelize-cli db:seed --seed 005-seed-from-sql-dump.js
```

## What Gets Seeded

### Roles (5 total)
1. **Admin** (level: 100) - Full system access
2. **Manager** (level: 50) - Management access
3. **Staff** (level: 10) - Standard staff access
4. **Doctor** (level: 0) - Doctor role
5. **Nurse** (level: 10) - Nurse role

### Permissions (119 total)
- **Resources:** users, patients, doctors, appointments, sales, purchases, stock, reports, settings, dashboard, emr, inpatients, laboratory, pharmacy, warehouse, expenses, suppliers
- **Actions:** create, read, update, delete, manage, export, import
- **Total:** 17 resources × 7 actions = 119 permissions

### Role-Permission Mappings
- **Admin:** Gets all 119 permissions (some disabled)
- **Manager:** Gets most permissions (excluding user management)
- **Staff:** Gets limited read/create/update permissions

### Default User
- **Username:** `admin`
- **Password:** `admin`
- **Role:** Admin (role_id: 1)
- **⚠️ IMPORTANT:** Change password after first login!

## Running Seeders

### Run All Seeders
```bash
cd backend
npx sequelize-cli db:seed:all
```

### Run Specific Seeder
```bash
cd backend
npx sequelize-cli db:seed --seed 005-seed-from-sql-dump.js
```

### Undo Seeding
```bash
cd backend
npx sequelize-cli db:seed:undo:all
# Or undo specific
npx sequelize-cli db:seed:undo --seed 005-seed-from-sql-dump.js
```

## Prerequisites

1. **Database Tables:** Must exist (run migrations first)
2. **SQL Dump File:** `clinic_pro_db.sql` must exist in project root (for seeder 005)
3. **Database Connection:** Configured in `.env` file

## Expected Output

```
🌱 Starting Users and Permissions Seeder...

═══════════════════════════════════════════════════════
   CLINIC PRO - SEED USERS & PERMISSIONS
═══════════════════════════════════════════════════════

📖 Reading SQL dump file...
   📝 Seeding permissions...
   ✅ Permissions seeded
   📝 Seeding roles...
   ✅ Roles seeded
   📝 Seeding role permissions...
   ✅ Role permissions seeded
   📝 Seeding users...
   ✅ Users seeded
   📋 Default login: username=admin, password=admin

✅ Seeding from dump file completed!

═══════════════════════════════════════════════════════
   ✨ SEEDING COMPLETED SUCCESSFULLY!
═══════════════════════════════════════════════════════

📋 Summary:
   • 5 Roles seeded (Admin, Manager, Staff, Doctor, Nurse)
   • 119 Permissions seeded
   • Role-permission mappings seeded
   • Admin user created

🔐 Default Login Credentials:
   Username: admin
   Password: admin
   ⚠️  Please change the password after first login!
```

## Troubleshooting

### Error: SQL dump file not found
- **Solution:** Ensure `clinic_pro_db.sql` exists in project root
- **Check:** `ls clinic_pro_db.sql` or `dir clinic_pro_db.sql`

### Error: Table doesn't exist
- **Solution:** Run migrations first
- **Command:** `node backend/migrations/run-create-all-tables.js`

### Error: Duplicate entry
- **Status:** Normal - seeder is idempotent
- **Action:** Data already exists, seeder will skip

### Error: Foreign key constraint fails
- **Solution:** Ensure tables are created in correct order
- **Action:** Run migrations first, then seeders

## Notes

- Seeders are **idempotent** - safe to run multiple times
- Data matches the SQL dump file exactly
- Admin password is hashed with bcrypt (password: "admin")
- Role-permission mappings match the dump file structure

## Next Steps

After seeding:

1. **Test Login:** Login with admin/admin
2. **Change Password:** Update admin password immediately
3. **Create Users:** Create additional users as needed
4. **Verify Permissions:** Check that permissions are working correctly

