/**
 * Standalone script to run the users and permissions seeder
 * Usage: node backend/seeders/run-seed-users-permissions.js
 */

require('dotenv').config({ path: require('path').join(__dirname, '../.env') });
const seedFromDump = require('./005-seed-from-sql-dump');

const runSeeder = async () => {
    try {
        console.log('🌱 Starting Users and Permissions Seeder...\n');
        console.log('═══════════════════════════════════════════════════════');
        console.log('   CLINIC PRO - SEED USERS & PERMISSIONS');
        console.log('═══════════════════════════════════════════════════════\n');

        // Import Sequelize and create queryInterface
        const { Sequelize } = require('sequelize');
        const sequelize = new Sequelize(
            process.env.DB_NAME || 'clinic_pro_db',
            process.env.DB_USER || 'root',
            process.env.DB_PASSWORD || '',
            {
                host: process.env.DB_HOST || '127.0.0.1',
                port: parseInt(process.env.DB_PORT) || 3306,
                dialect: 'mysql',
                logging: false,
                pool: {
                    max: 5,
                    min: 0,
                    acquire: 30000,
                    idle: 10000
                }
            }
        );

        // Create queryInterface
        const queryInterface = sequelize.getQueryInterface();

        // Run the seeder
        await seedFromDump.up(queryInterface, Sequelize);

        console.log('\n═══════════════════════════════════════════════════════');
        console.log('   ✨ SEEDING COMPLETED SUCCESSFULLY!');
        console.log('═══════════════════════════════════════════════════════\n');

        console.log('📋 Summary:');
        console.log('   • 5 Roles seeded (Admin, Manager, Staff, Doctor, Nurse)');
        console.log('   • 119 Permissions seeded');
        console.log('   • Role-permission mappings seeded');
        console.log('   • Admin user created');
        console.log('\n🔐 Default Login Credentials:');
        console.log('   Username: admin');
        console.log('   Password: admin');
        console.log('   ⚠️  Please change the password after first login!\n');

        await sequelize.close();
        process.exit(0);

    } catch (error) {
        console.error('\n❌ SEEDING FAILED');
        console.error('   Error:', error.message);
        console.error('   Stack:', error.stack);
        console.error('\nTroubleshooting:');
        console.error('   1. Check database connection in .env file');
        console.error('   2. Ensure clinic_pro_db.sql exists in project root');
        console.error('   3. Verify tables exist (run migrations first)');
        console.error('   4. Check database permissions\n');
        process.exit(1);
    }
};

// Run if called directly
if (require.main === module) {
    runSeeder();
}

module.exports = runSeeder;

