/**
 * Add status column to appointments table
 */

const fs = require('fs');
const path = require('path');
const { query } = require('../config/database');

async function addAppointmentStatus() {
    try {
        console.log('🔄 Adding status column to appointments...');

        // Add status column
        await query(`
            ALTER TABLE tbl_appointment 
            ADD COLUMN status VARCHAR(20) DEFAULT 'scheduled'
        `).catch(() => {
            console.log('Status column already exists or error adding it');
        });

        // Update existing appointments
        await query(`
            UPDATE tbl_appointment 
            SET status = 'scheduled' 
            WHERE status IS NULL OR status = ''
        `);

        console.log('✅ Status column added successfully!');
        console.log('✅ Existing appointments updated with default status');

        // Add indexes
        await query(`
            ALTER TABLE tbl_appointment 
            ADD INDEX idx_status (status)
        `).catch(() => {
            console.log('Index idx_status already exists');
        });

        console.log('✅ Indexes added successfully!');
        console.log('\n📊 Status values:');
        console.log('   - scheduled  : Appointment is scheduled');
        console.log('   - arrived    : Patient has arrived');
        console.log('   - in-progress: Patient is being treated');
        console.log('   - completed  : Appointment completed');
        console.log('   - cancelled  : Appointment cancelled');
        console.log('   - no-show    : Patient did not show up');

        process.exit(0);
    } catch (error) {
        console.error('❌ Error:', error);
        process.exit(1);
    }
}

addAppointmentStatus();

