/**
 * Add doctor_id and doctor_name columns to voucher tables
 */

const { query } = require('../config/database');

async function addDoctorToVoucher() {
    try {
        console.log('🔄 Adding doctor columns to voucher tables...');

        // Add to tbl_voucher
        await query(`
            ALTER TABLE tbl_voucher 
            ADD COLUMN doctor_id INT NULL,
            ADD COLUMN doctor_name VARCHAR(100) NULL,
            ADD COLUMN patient_id INT NULL
        `).catch(() => {
            console.log('Columns may already exist in tbl_voucher');
        });

        // Add indexes
        await query(`
            ALTER TABLE tbl_voucher 
            ADD INDEX idx_doctor_id (doctor_id)
        `).catch(() => {
            console.log('Index idx_doctor_id may already exist');
        });

        await query(`
            ALTER TABLE tbl_voucher 
            ADD INDEX idx_patient_id (patient_id)
        `).catch(() => {
            console.log('Index idx_patient_id may already exist');
        });

        // Add to tbl_voucher_return
        await query(`
            ALTER TABLE tbl_voucher_return 
            ADD COLUMN doctor_id INT NULL,
            ADD COLUMN doctor_name VARCHAR(100) NULL,
            ADD COLUMN patient_id INT NULL
        `).catch(() => {
            console.log('Columns may already exist in tbl_voucher_return');
        });

        // Add to tbl_voucher_archive
        await query(`
            ALTER TABLE tbl_voucher_archive 
            ADD COLUMN doctor_id INT NULL,
            ADD COLUMN doctor_name VARCHAR(100) NULL,
            ADD COLUMN patient_id INT NULL
        `).catch(() => {
            console.log('Columns may already exist in tbl_voucher_archive');
        });

        console.log('✅ Doctor columns added successfully!');
        console.log('✅ Indexes created successfully!');
        console.log('\n📊 New columns in tbl_voucher:');
        console.log('   - doctor_id (INT)');
        console.log('   - doctor_name (VARCHAR)');
        console.log('   - patient_id (INT)');
        console.log('\n✅ POS sales can now track prescribing doctors!');

        process.exit(0);
    } catch (error) {
        console.error('❌ Error:', error);
        process.exit(1);
    }
}

addDoctorToVoucher();

