const { query } = require('../config/database');
const fs = require('fs');
const path = require('path');

async function cleanDoctorPhotos() {
    try {
        console.log('🔍 Checking doctor photos...');
        
        // Get all doctors with photos
        const doctors = await query('SELECT id, name, photo FROM tbl_doctor WHERE photo IS NOT NULL');
        console.log(`Found ${doctors.length} doctors with photo references`);
        
        let cleaned = 0;
        let valid = 0;
        
        for (const doctor of doctors) {
            const photoPath = path.join(__dirname, '../', doctor.photo);
            const exists = fs.existsSync(photoPath);
            
            console.log(`\nDoctor: ${doctor.name}`);
            console.log(`  Photo path: ${doctor.photo}`);
            console.log(`  Full path: ${photoPath}`);
            console.log(`  File exists: ${exists}`);
            
            if (!exists) {
                console.log(`  ❌ File not found - cleaning database reference...`);
                await query('UPDATE tbl_doctor SET photo = NULL WHERE id = ?', [doctor.id]);
                cleaned++;
            } else {
                console.log(`  ✅ File exists - keeping reference`);
                valid++;
            }
        }
        
        console.log('\n📊 Summary:');
        console.log(`  ✅ Valid photos: ${valid}`);
        console.log(`  ❌ Cleaned (missing files): ${cleaned}`);
        console.log(`  📁 Total checked: ${doctors.length}`);
        
    } catch (error) {
        console.error('❌ Error:', error);
    } finally {
        process.exit(0);
    }
}

cleanDoctorPhotos();
