-- Create deposit transactions table
CREATE TABLE IF NOT EXISTS tbl_deposit_transaction (
    id INT AUTO_INCREMENT PRIMARY KEY,
    patient_id INT NOT NULL,
    transaction_type ENUM('deposit', 'withdrawal', 'refund', 'adjustment') NOT NULL,
    amount DECIMAL(10,2) NOT NULL,
    balance_after DECIMAL(10,2) NOT NULL,
    description TEXT,
    reference_no VARCHAR(50),
    created_by INT,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    status ENUM('active', 'cancelled') DEFAULT 'active',
    
    INDEX idx_patient_id (patient_id),
    INDEX idx_transaction_type (transaction_type),
    INDEX idx_created_at (created_at),
    INDEX idx_reference_no (reference_no),
    
    FOREIGN KEY (patient_id) REFERENCES tbl_patient(id) ON DELETE CASCADE,
    FOREIGN KEY (created_by) REFERENCES tbl_user(id) ON DELETE SET NULL
);

-- Add deposit balance column to patient table if it doesn't exist
ALTER TABLE tbl_patient 
ADD COLUMN IF NOT EXISTS deposit_balance DECIMAL(10,2) DEFAULT 0.00 AFTER deposit;

-- Update existing patients to have deposit_balance equal to deposit
UPDATE tbl_patient 
SET deposit_balance = COALESCE(deposit, 0) 
WHERE deposit_balance IS NULL OR deposit_balance = 0;
