const { query } = require('../config/database');

async function fixBedData() {
    try {
        console.log('🔧 Fixing inconsistent bed data...');

        // Fix beds that are marked as Occupied but have no patient_id
        const result = await query(`
            UPDATE tbl_beds 
            SET status = 'Available', current_patient_id = NULL, admission_date = NULL
            WHERE status = 'Occupied' AND (current_patient_id IS NULL OR current_patient_id = '')
        `);

        console.log(`✅ Fixed ${result.affectedRows} beds with inconsistent data`);

        // Show updated bed status
        const allBeds = await query('SELECT * FROM tbl_beds ORDER BY department_id, room_number, bed_number');
        const availableBeds = allBeds.filter(bed => bed.status === 'Available');
        const occupiedBeds = allBeds.filter(bed => bed.status === 'Occupied');

        console.log(`\n📊 Updated bed status:`);
        console.log(`  Available: ${availableBeds.length} beds`);
        console.log(`  Occupied: ${occupiedBeds.length} beds`);

        console.log(`\n✅ Available beds for admission:`);
        availableBeds.forEach(bed => {
            console.log(`  - ID: ${bed.id}, Bed: ${bed.bed_number}, Room: ${bed.room_number}, Type: ${bed.bed_type}`);
        });

    } catch (error) {
        console.error('❌ Error fixing bed data:', error);
    } finally {
        console.log('\nBed data fix completed');
    }
}

fixBedData();
