/**
 * Fix tbl_purchase table AUTO_INCREMENT issue
 */

const { query } = require('../config/database');

async function fixPurchaseTable() {
    try {
        console.log('🔄 Fixing tbl_purchase table...');

        // Check current table structure
        const columns = await query('SHOW COLUMNS FROM tbl_purchase');
        console.log('\n📊 Current tbl_purchase structure:');
        columns.forEach(col => {
            if (col.Field === 'id') {
                console.log(`   ${col.Field}: ${col.Type} ${col.Null} ${col.Key} ${col.Extra}`);
            }
        });

        // Fix AUTO_INCREMENT
        console.log('\n🔧 Adding AUTO_INCREMENT to id column...');
        await query('ALTER TABLE tbl_purchase MODIFY COLUMN id INT NOT NULL AUTO_INCREMENT');

        // Ensure PRIMARY KEY
        await query('ALTER TABLE tbl_purchase ADD PRIMARY KEY (id)').catch(() => {
            console.log('Primary key already exists');
        });

        // Set AUTO_INCREMENT start value
        const maxIdResult = await query('SELECT COALESCE(MAX(id), 0) as max_id FROM tbl_purchase');
        const maxId = maxIdResult[0].max_id;
        await query(`ALTER TABLE tbl_purchase AUTO_INCREMENT = ${maxId + 1}`);

        console.log(`✅ AUTO_INCREMENT set to start from ${maxId + 1}`);

        // Verify fix
        const newColumns = await query('SHOW COLUMNS FROM tbl_purchase WHERE Field = "id"');
        console.log('\n✅ Fixed structure:');
        newColumns.forEach(col => {
            console.log(`   ${col.Field}: ${col.Type} ${col.Null} ${col.Key} ${col.Extra}`);
        });

        console.log('\n🎉 tbl_purchase table fixed! Purchases can now be saved.');
        
        process.exit(0);
    } catch (error) {
        console.error('❌ Error fixing table:', error);
        process.exit(1);
    }
}

fixPurchaseTable();
