const { query } = require('../config/database');
const fs = require('fs');
const path = require('path');

async function updateInpatientTable() {
    try {
        console.log('🏥 Updating inpatient table for bed integration...');

        // Read SQL script
        const sqlScriptPath = path.join(__dirname, 'update-inpatient-table.sql');
        const sqlScript = fs.readFileSync(sqlScriptPath, 'utf8');

        // Execute SQL script
        const statements = sqlScript.split(';').filter(s => s.trim().length > 0);
        for (const statement of statements) {
            if (statement.trim()) {
                try {
                    await query(statement);
                    console.log('✅ Executed:', statement.substring(0, 50) + '...');
                } catch (error) {
                    if (error.code === 'ER_DUP_KEYNAME' || error.code === 'ER_DUP_FIELDNAME') {
                        console.log('⚠️  Skipped (already exists):', statement.substring(0, 50) + '...');
                    } else {
                        console.error('❌ Error executing:', statement.substring(0, 50) + '...');
                        console.error('Error:', error.message);
                    }
                }
            }
        }

        console.log('🎉 Inpatient table update completed successfully!');
        
        // Verify the changes
        const verifySql = 'DESCRIBE tbl_inpatient';
        const columns = await query(verifySql);
        console.log('\n📋 Updated tbl_inpatient columns:');
        columns.forEach(col => {
            if (['bed_id', 'bed_number', 'bed_type', 'daily_rate', 'dr_id'].includes(col.Field)) {
                console.log(`  ✅ ${col.Field}: ${col.Type} ${col.Null === 'YES' ? '(nullable)' : '(not null)'}`);
            }
        });

    } catch (error) {
        console.error('❌ Error updating inpatient table:', error);
    } finally {
        console.log('\nSetup completed');
    }
}

updateInpatientTable();
