-- Update tbl_inpatient table to include bed-related fields
-- This script adds new columns for bed management integration

-- Add bed-related columns to tbl_inpatient table
ALTER TABLE tbl_inpatient 
ADD COLUMN IF NOT EXISTS bed_id INT NULL,
ADD COLUMN IF NOT EXISTS bed_number VARCHAR(20) NULL,
ADD COLUMN IF NOT EXISTS bed_type VARCHAR(50) NULL,
ADD COLUMN IF NOT EXISTS daily_rate DECIMAL(10,2) DEFAULT 0.00,
ADD COLUMN IF NOT EXISTS dr_id INT NULL;

-- Add foreign key constraint for bed_id
ALTER TABLE tbl_inpatient 
ADD CONSTRAINT fk_inpatient_bed 
FOREIGN KEY (bed_id) REFERENCES tbl_beds(id) ON DELETE SET NULL;

-- Add foreign key constraint for dr_id
ALTER TABLE tbl_inpatient 
ADD CONSTRAINT fk_inpatient_doctor 
FOREIGN KEY (dr_id) REFERENCES tbl_doctor(id) ON DELETE SET NULL;

-- Add indexes for better performance
CREATE INDEX IF NOT EXISTS idx_inpatient_bed_id ON tbl_inpatient(bed_id);
CREATE INDEX IF NOT EXISTS idx_inpatient_dr_id ON tbl_inpatient(dr_id);
CREATE INDEX IF NOT EXISTS idx_inpatient_end_date ON tbl_inpatient(end_date);

-- Update existing records to set default values
UPDATE tbl_inpatient 
SET bed_type = 'General', daily_rate = 0.00 
WHERE bed_type IS NULL;

-- Add comments for documentation
ALTER TABLE tbl_inpatient 
MODIFY COLUMN bed_id INT NULL COMMENT 'Reference to tbl_beds.id',
MODIFY COLUMN bed_number VARCHAR(20) NULL COMMENT 'Bed number from bed assignment',
MODIFY COLUMN bed_type VARCHAR(50) NULL COMMENT 'Type of bed (General, ICU, Private, etc.)',
MODIFY COLUMN daily_rate DECIMAL(10,2) DEFAULT 0.00 COMMENT 'Daily rate for bed',
MODIFY COLUMN dr_id INT NULL COMMENT 'Reference to tbl_doctor.id';
