-- Clinic Pro V3 Database Backup
-- Created: 2025-10-12T15:47:38.670Z
-- Tables: 49

SET FOREIGN_KEY_CHECKS=0;

-- Table: tbl_alert
DROP TABLE IF EXISTS `tbl_alert`;
CREATE TABLE `tbl_alert` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cat_name` varchar(50) DEFAULT NULL,
  `barcode` varchar(50) DEFAULT NULL,
  `name` varchar(50) DEFAULT NULL,
  `qty` int(11) DEFAULT NULL,
  `qty_alert` int(11) DEFAULT NULL,
  `date` date DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table: tbl_appointment
DROP TABLE IF EXISTS `tbl_appointment`;
CREATE TABLE `tbl_appointment` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) DEFAULT NULL,
  `phone` varchar(50) DEFAULT NULL,
  `case_` varchar(50) DEFAULT NULL,
  `dr_name` varchar(50) DEFAULT NULL,
  `token_number` varchar(50) DEFAULT NULL,
  `time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table: tbl_case
DROP TABLE IF EXISTS `tbl_case`;
CREATE TABLE `tbl_case` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data for table: tbl_case
INSERT INTO `tbl_case` (`id`, `name`) VALUES
(1, 'Fever'),
(2, 'Cold & Flu'),
(3, 'Headache'),
(4, 'Stomach Pain'),
(5, 'Injury'),
(6, 'Diabetes'),
(7, 'Hypertension'),
(8, 'Check-up'),
(9, 'Follow-up'),
(10, 'Vaccination');

-- Table: tbl_cat_expenses
DROP TABLE IF EXISTS `tbl_cat_expenses`;
CREATE TABLE `tbl_cat_expenses` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data for table: tbl_cat_expenses
INSERT INTO `tbl_cat_expenses` (`id`, `name`) VALUES
(1, 'Salary'),
(2, 'Utilities'),
(3, 'Rent'),
(4, 'Maintenance'),
(5, 'Office Supplies'),
(6, 'Transportation');

-- Table: tbl_catalog
DROP TABLE IF EXISTS `tbl_catalog`;
CREATE TABLE `tbl_catalog` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data for table: tbl_catalog
INSERT INTO `tbl_catalog` (`id`, `name`) VALUES
(1, 'Tablets'),
(2, 'Capsules'),
(3, 'Syrup'),
(4, 'Injection'),
(5, 'Medical Equipment'),
(6, 'First Aid'),
(7, 'Vitamins & Supplements');

-- Table: tbl_catalog_2
DROP TABLE IF EXISTS `tbl_catalog_2`;
CREATE TABLE `tbl_catalog_2` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table: tbl_customer
DROP TABLE IF EXISTS `tbl_customer`;
CREATE TABLE `tbl_customer` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) DEFAULT NULL,
  `ph_no` varchar(50) DEFAULT NULL,
  `nrc_no` varchar(50) DEFAULT NULL,
  `shop` text DEFAULT NULL,
  `address` text DEFAULT NULL,
  `date` date DEFAULT NULL,
  `remark` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data for table: tbl_customer
INSERT INTO `tbl_customer` (`id`, `name`, `ph_no`, `nrc_no`, `shop`, `address`, `date`, `remark`) VALUES
(1, 'Aung Aung', '09-111111111', '12/YKNXXX', 'Aung Aung Pharmacy', 'Downtown, Yangon', '2025-10-12 00:00:00', 'Regular customer'),
(2, 'Ma Mya', '09-222222222', '12/YGNXXX', 'Mya Mya Medical Store', 'Sanchaung, Yangon', '2025-10-12 00:00:00', 'VIP customer'),
(3, 'Ko Htun', '09-333333333', '14/MGBXXX', 'Htun Medical Center', 'Mandalay', '2025-10-12 00:00:00', 'Good credit'),
(4, 'Daw Tin', '09-444444444', '12/DGNXXX', 'Tin Tin Clinic', 'Dagon, Yangon', '2025-10-12 00:00:00', 'Monthly payment'),
(5, 'U Myint', '09-555555555', '12/THNXXX', 'Myint Medical Shop', 'Thingangyun, Yangon', '2025-10-12 00:00:00', 'Wholesale buyer'),
(6, 'Ma Su', '09-666666666', '12/KMNXXX', 'Su Su Pharmacy', 'Kamayut, Yangon', '2025-10-12 00:00:00', 'Retail customer'),
(7, 'Ko Win', '09-777777777', '13/PYTXXX', 'Win Win Clinic', 'Pyay', '2025-10-12 00:00:00', 'Regional customer'),
(8, 'Daw Khin', '09-888888888', '12/BTNXXX', 'Khin Medical', 'Botataung, Yangon', '2025-10-12 00:00:00', 'Cash only'),
(9, 'U Zaw', '09-999999999', '12/YKNXXX', 'Zaw Health Center', 'Yankin, Yangon', '2025-10-12 00:00:00', 'Credit customer'),
(10, 'Ma Hla', '09-101010101', '12/HGLXXX', 'Hla Pharmacy', 'Hlaing, Yangon', '2025-10-12 00:00:00', 'New customer');

-- Table: tbl_customer_debt
DROP TABLE IF EXISTS `tbl_customer_debt`;
CREATE TABLE `tbl_customer_debt` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `customer_id` int(11) NOT NULL,
  `voucher_id` int(11) DEFAULT NULL,
  `debt` double DEFAULT NULL,
  `pay` double DEFAULT NULL,
  `remark` text DEFAULT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table: tbl_doctor
DROP TABLE IF EXISTS `tbl_doctor`;
CREATE TABLE `tbl_doctor` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) DEFAULT NULL,
  `phone` varchar(50) DEFAULT NULL,
  `education` varchar(250) DEFAULT NULL,
  `specialist` varchar(250) DEFAULT NULL,
  `remark` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data for table: tbl_doctor
INSERT INTO `tbl_doctor` (`id`, `name`, `phone`, `education`, `specialist`, `remark`) VALUES
(1, 'Dr. Aung Aung', '09-111111111', 'MBBS, MD', 'General Physician', 'Available Mon-Fri'),
(2, 'Dr. Su Su', '09-222222222', 'MBBS, MD (Peds)', 'Pediatrician', 'Available Mon-Sat'),
(3, 'Dr. Kyaw Kyaw', '09-333333333', 'MBBS, MS (Ortho)', 'Orthopedic Surgeon', 'Available on appointment');

-- Table: tbl_expenses
DROP TABLE IF EXISTS `tbl_expenses`;
CREATE TABLE `tbl_expenses` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cat_exp_id` varchar(50) NOT NULL,
  `amount` double NOT NULL,
  `user_name` varchar(50) NOT NULL,
  `reason` varchar(50) NOT NULL,
  `remark` varchar(50) DEFAULT NULL,
  `date` date NOT NULL,
  `status` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table: tbl_form
DROP TABLE IF EXISTS `tbl_form`;
CREATE TABLE `tbl_form` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `role_id` varchar(50) NOT NULL,
  `sale` varchar(50) NOT NULL,
  `buy` varchar(50) NOT NULL,
  `product` varchar(50) NOT NULL,
  `change_item_price` varchar(50) NOT NULL,
  `cashier` varchar(50) NOT NULL,
  `login_user` varchar(50) NOT NULL,
  `customer` varchar(50) NOT NULL,
  `supplier` varchar(50) NOT NULL,
  `barcode` varchar(50) NOT NULL,
  `expenses` varchar(50) NOT NULL,
  `report` varchar(50) NOT NULL,
  `setting` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table: tbl_images
DROP TABLE IF EXISTS `tbl_images`;
CREATE TABLE `tbl_images` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` varchar(50) DEFAULT NULL,
  `treatment_id` int(11) DEFAULT NULL,
  `image` longblob DEFAULT NULL,
  `image_path` varchar(255) DEFAULT NULL,
  `upload_date` datetime DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table: tbl_inpatient
DROP TABLE IF EXISTS `tbl_inpatient`;
CREATE TABLE `tbl_inpatient` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) DEFAULT NULL,
  `age` varchar(50) DEFAULT NULL,
  `phone` varchar(50) DEFAULT NULL,
  `address` varchar(250) DEFAULT NULL,
  `case_` text DEFAULT NULL,
  `remark` text DEFAULT NULL,
  `start_date` date DEFAULT NULL,
  `dr_name` varchar(250) DEFAULT NULL,
  `patient_id` varchar(250) DEFAULT NULL,
  `room_no` varchar(250) DEFAULT NULL,
  `deposit` int(11) DEFAULT NULL,
  `end_date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data for table: tbl_inpatient
INSERT INTO `tbl_inpatient` (`id`, `name`, `age`, `phone`, `address`, `case_`, `remark`, `start_date`, `dr_name`, `patient_id`, `room_no`, `deposit`, `end_date`) VALUES
(1, 'U Than Tun', '58', '09-121212121', 'Sanchaung, Yangon', 'Pneumonia', 'Admitted for IV antibiotics', '2025-10-09 00:00:00', 'Dr. Aung Aung', 'IPD-001', 'R-101', 500000, NULL),
(2, 'Daw Sandar', '47', '09-232323232', 'Kamayut, Yangon', 'Appendicitis', 'Post-surgery recovery', '2025-10-07 00:00:00', 'Dr. Myo Myo', 'IPD-002', 'R-102', 800000, NULL),
(3, 'Ko Nyi', '35', '09-343434343', 'Bahan, Yangon', 'Dengue Fever', 'Platelet monitoring', '2025-10-10 00:00:00', 'Dr. Aung Aung', 'IPD-003', 'R-103', 400000, NULL),
(4, 'Ma Hnin', '29', '09-454545454', 'Yankin, Yangon', 'Delivery - C-Section', 'Mother and baby healthy', '2025-10-11 00:00:00', 'Dr. Myo Myo', 'IPD-004', 'R-201', 1000000, NULL),
(5, 'U Kyaw Soe', '62', '09-565656565', 'Hlaing, Yangon', 'Stroke', 'Stable condition, physiotherapy started', '2025-10-05 00:00:00', 'Dr. Aung Aung', 'IPD-005', 'R-104', 1500000, NULL),
(6, 'Daw Myint', '52', '09-676767676', 'Thingangyun, Yangon', 'Kidney Stones', 'Awaiting procedure', '2025-10-11 00:00:00', 'Dr. Myo Myo', 'IPD-006', 'R-105', 600000, NULL),
(7, 'Ko Htet', '40', '09-787878787', 'Mayangone, Yangon', 'Traffic Accident', 'Fracture treatment', '2025-10-08 00:00:00', 'Dr. Aung Aung', 'IPD-007', 'R-106', 700000, NULL),
(8, 'Ma Phyu', '26', '09-898989898', 'Dagon, Yangon', 'Severe Dehydration', 'IV fluids treatment', '2025-10-12 00:00:00', 'Dr. Myo Myo', 'IPD-008', 'R-202', 300000, NULL),
(9, 'U Win Htun', '55', '09-909090909', 'Botataung, Yangon', 'Gastric Ulcer', 'Medical management', '2025-10-10 00:00:00', 'Dr. Aung Aung', 'IPD-009', 'R-107', 450000, NULL),
(10, 'Daw Yin', '43', '09-101010101', 'Insein, Yangon', 'Gallbladder Surgery', 'Post-op day 3', '2025-10-09 00:00:00', 'Dr. Myo Myo', 'IPD-010', 'R-203', 900000, NULL);

-- Table: tbl_inpatient_sale
DROP TABLE IF EXISTS `tbl_inpatient_sale`;
CREATE TABLE `tbl_inpatient_sale` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cat_id` text DEFAULT NULL,
  `Barcode` varchar(50) DEFAULT NULL,
  `Name` text DEFAULT NULL,
  `SaleType` varchar(50) DEFAULT NULL,
  `SalePrice` double DEFAULT NULL,
  `dis` double DEFAULT NULL,
  `Qty` int(11) DEFAULT NULL,
  `Total` double DEFAULT NULL,
  `Profit` double DEFAULT NULL,
  `VNo` int(11) DEFAULT NULL,
  `Date` date DEFAULT NULL,
  `Cashier` varchar(50) DEFAULT NULL,
  `patient_id` varchar(250) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table: tbl_inpatient_saledebit
DROP TABLE IF EXISTS `tbl_inpatient_saledebit`;
CREATE TABLE `tbl_inpatient_saledebit` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` varchar(250) NOT NULL,
  `voucher_id` int(11) DEFAULT NULL,
  `debt` double DEFAULT NULL,
  `pay` double DEFAULT NULL,
  `remark` text DEFAULT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table: tbl_labour
DROP TABLE IF EXISTS `tbl_labour`;
CREATE TABLE `tbl_labour` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `level_name` varchar(50) DEFAULT NULL,
  `name` varchar(250) DEFAULT NULL,
  `sex` varchar(10) DEFAULT NULL,
  `age` varchar(50) DEFAULT NULL,
  `nrc` varchar(250) DEFAULT NULL,
  `ph_no` varchar(50) DEFAULT NULL,
  `address` varchar(250) DEFAULT NULL,
  `work_in` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table: tbl_labour_balance
DROP TABLE IF EXISTS `tbl_labour_balance`;
CREATE TABLE `tbl_labour_balance` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `labour_name` varchar(50) NOT NULL,
  `InMoney` int(11) DEFAULT NULL,
  `OutMoney` int(11) DEFAULT NULL,
  `About` text DEFAULT NULL,
  `Remark` text DEFAULT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table: tbl_labour_level
DROP TABLE IF EXISTS `tbl_labour_level`;
CREATE TABLE `tbl_labour_level` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `salary` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table: tbl_loss
DROP TABLE IF EXISTS `tbl_loss`;
CREATE TABLE `tbl_loss` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_name` varchar(50) DEFAULT NULL,
  `cat_id` text DEFAULT NULL,
  `barcode` varchar(50) DEFAULT NULL,
  `name` varchar(50) DEFAULT NULL,
  `qty` int(11) DEFAULT NULL,
  `cost_price` double DEFAULT NULL,
  `total_cost` double DEFAULT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table: tbl_patient
DROP TABLE IF EXISTS `tbl_patient`;
CREATE TABLE `tbl_patient` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) DEFAULT NULL,
  `age` varchar(50) DEFAULT NULL,
  `phone` varchar(50) DEFAULT NULL,
  `address` varchar(250) DEFAULT NULL,
  `case_` text DEFAULT NULL,
  `remark` text DEFAULT NULL,
  `date` date DEFAULT NULL,
  `dr_name` varchar(250) DEFAULT NULL,
  `patient_id` varchar(250) DEFAULT NULL,
  `room_no` varchar(250) DEFAULT NULL,
  `deposit` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_patient_patient_id` (`patient_id`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data for table: tbl_patient
INSERT INTO `tbl_patient` (`id`, `name`, `age`, `phone`, `address`, `case_`, `remark`, `date`, `dr_name`, `patient_id`, `room_no`, `deposit`) VALUES
(1, 'Ko Kyaw', '35', '09-111222333', 'Sanchaung Township, Yangon', 'Common Cold', 'Follow-up in 3 days', '2025-10-12 00:00:00', 'Dr. Aung Aung', 'OPD-001', NULL, NULL),
(2, 'Ma Thandar', '28', '09-222333444', 'Kamayut Township, Yangon', 'Hypertension', 'Regular checkup needed', '2025-10-12 00:00:00', 'Dr. Myo Myo', 'OPD-002', NULL, NULL),
(3, 'U Tin Win', '55', '09-333444555', 'Bahan Township, Yangon', 'Diabetes Type 2', 'Monitor blood sugar', '2025-10-12 00:00:00', 'Dr. Aung Aung', 'OPD-003', NULL, NULL),
(4, 'Daw Aye', '48', '09-444555666', 'Yankin Township, Yangon', 'Back Pain', 'Physiotherapy recommended', '2025-10-12 00:00:00', 'Dr. Myo Myo', 'OPD-004', NULL, NULL),
(5, 'Ko Zaw', '42', '09-555666777', 'Thingangyun Township, Yangon', 'Gastritis', 'Dietary advice given', '2025-10-12 00:00:00', 'Dr. Aung Aung', 'OPD-005', NULL, NULL),
(6, 'Ma Su', '25', '09-666777888', 'Mayangone Township, Yangon', 'Migraine', 'Stress management needed', '2025-10-12 00:00:00', 'Dr. Myo Myo', 'OPD-006', NULL, NULL),
(7, 'U Htun', '60', '09-777888999', 'Hlaing Township, Yangon', 'Arthritis', 'Pain management plan', '2025-10-12 00:00:00', 'Dr. Aung Aung', 'OPD-007', NULL, NULL),
(8, 'Daw Khin', '38', '09-888999000', 'Dagon Township, Yangon', 'Asthma', 'Inhaler prescribed', '2025-10-12 00:00:00', 'Dr. Myo Myo', 'OPD-008', NULL, NULL),
(9, 'Ko Win', '30', '09-999000111', 'Botataung Township, Yangon', 'Skin Allergy', 'Avoid allergens', '2025-10-12 00:00:00', 'Dr. Aung Aung', 'OPD-009', NULL, NULL),
(10, 'Ma Hla', '33', '09-000111222', 'Pazundaung Township, Yangon', 'Fever', 'Rest and hydration', '2025-10-12 00:00:00', 'Dr. Myo Myo', 'OPD-010', NULL, NULL),
(11, 'U Myint', '50', '09-111222444', 'Insein Township, Yangon', 'High Cholesterol', 'Diet control needed', '2025-10-12 00:00:00', 'Dr. Aung Aung', 'OPD-011', NULL, NULL),
(12, 'Daw Mya', '45', '09-222333555', 'Thaketa Township, Yangon', 'Thyroid Disorder', 'Regular medication', '2025-10-12 00:00:00', 'Dr. Myo Myo', 'OPD-012', NULL, NULL),
(13, 'Ko Aung', '27', '09-333444666', 'North Okkalapa, Yangon', 'Sports Injury', 'Rest for 2 weeks', '2025-10-12 00:00:00', 'Dr. Aung Aung', 'OPD-013', NULL, NULL),
(14, 'Ma Wai', '31', '09-444555777', 'South Okkalapa, Yangon', 'Pregnancy Checkup', 'All normal', '2025-10-12 00:00:00', 'Dr. Myo Myo', 'OPD-014', NULL, NULL),
(15, 'U Sein', '65', '09-555666888', 'Mingalar Taung Nyunt, Yangon', 'Heart Disease', 'Cardiologist referral', '2025-10-12 00:00:00', 'Dr. Aung Aung', 'OPD-015', NULL, NULL);

-- Table: tbl_patient_sale
DROP TABLE IF EXISTS `tbl_patient_sale`;
CREATE TABLE `tbl_patient_sale` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cat_id` text DEFAULT NULL,
  `Barcode` varchar(50) DEFAULT NULL,
  `Name` text DEFAULT NULL,
  `SaleType` varchar(50) DEFAULT NULL,
  `SalePrice` double DEFAULT NULL,
  `dis` double DEFAULT NULL,
  `Qty` int(11) DEFAULT NULL,
  `Total` double DEFAULT NULL,
  `Profit` double DEFAULT NULL,
  `VNo` int(11) DEFAULT NULL,
  `Date` date DEFAULT NULL,
  `Cashier` varchar(50) DEFAULT NULL,
  `patient_id` varchar(250) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table: tbl_payment_method
DROP TABLE IF EXISTS `tbl_payment_method`;
CREATE TABLE `tbl_payment_method` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data for table: tbl_payment_method
INSERT INTO `tbl_payment_method` (`id`, `name`) VALUES
(1, 'Cash'),
(2, 'KBZ Pay'),
(3, 'CB Pay'),
(4, 'Aya Pay'),
(5, 'Wave Money'),
(6, 'Bank Transfer');

-- Table: tbl_purchase
DROP TABLE IF EXISTS `tbl_purchase`;
CREATE TABLE `tbl_purchase` (
  `id` int(11) NOT NULL,
  `purchase_voucher_id` int(11) DEFAULT NULL,
  `cat_id` varchar(255) DEFAULT NULL,
  `cat_id_2` varchar(50) DEFAULT NULL,
  `barcode` varchar(50) DEFAULT NULL,
  `name` text DEFAULT NULL,
  `qty` int(11) DEFAULT NULL,
  `qty_alert` int(11) DEFAULT NULL,
  `unit_name` varchar(50) DEFAULT NULL,
  `cost_price` int(11) DEFAULT NULL,
  `total_cost_price` int(11) DEFAULT NULL,
  `sale_price_latli` int(11) DEFAULT NULL,
  `sale_price_latkar` int(11) DEFAULT NULL,
  `remark` varchar(255) DEFAULT NULL,
  `date` date DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  `expire_date` date DEFAULT NULL,
  `alert_month` int(11) DEFAULT NULL,
  `alert_date` date DEFAULT NULL,
  `margin` double DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table: tbl_purchase_return
DROP TABLE IF EXISTS `tbl_purchase_return`;
CREATE TABLE `tbl_purchase_return` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_name` varchar(50) DEFAULT NULL,
  `cat_id` text DEFAULT NULL,
  `barcode` varchar(50) DEFAULT NULL,
  `name` varchar(50) DEFAULT NULL,
  `qty` int(11) DEFAULT NULL,
  `unit_name` varchar(50) DEFAULT NULL,
  `cost_price` double DEFAULT NULL,
  `total_cost` double DEFAULT NULL,
  `date` date DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table: tbl_purchase_voucher
DROP TABLE IF EXISTS `tbl_purchase_voucher`;
CREATE TABLE `tbl_purchase_voucher` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_name` varchar(50) DEFAULT NULL,
  `total_cost` double NOT NULL,
  `supplier_name` varchar(50) DEFAULT NULL,
  `Date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table: tbl_role
DROP TABLE IF EXISTS `tbl_role`;
CREATE TABLE `tbl_role` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data for table: tbl_role
INSERT INTO `tbl_role` (`id`, `name`) VALUES
(1, 'Admin'),
(2, 'Manager'),
(3, 'Cashier'),
(4, 'Doctor');

-- Table: tbl_sale
DROP TABLE IF EXISTS `tbl_sale`;
CREATE TABLE `tbl_sale` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cat_id` text DEFAULT NULL,
  `Barcode` varchar(50) DEFAULT NULL,
  `Name` text DEFAULT NULL,
  `SaleType` varchar(50) DEFAULT NULL,
  `SalePrice` double DEFAULT NULL,
  `dis` double DEFAULT NULL,
  `Qty` int(11) DEFAULT NULL,
  `Total` double DEFAULT NULL,
  `Profit` double DEFAULT NULL,
  `VNo` int(11) DEFAULT NULL,
  `Date` date DEFAULT NULL,
  `Cashier` varchar(50) DEFAULT NULL,
  `Refer` varchar(250) DEFAULT NULL,
  `cost_price` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_sale_vno` (`VNo`),
  KEY `idx_sale_date` (`Date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table: tbl_sale_archive
DROP TABLE IF EXISTS `tbl_sale_archive`;
CREATE TABLE `tbl_sale_archive` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cat_id` text DEFAULT NULL,
  `Barcode` varchar(50) DEFAULT NULL,
  `Name` text DEFAULT NULL,
  `SaleType` varchar(50) DEFAULT NULL,
  `SalePrice` double DEFAULT NULL,
  `dis` double DEFAULT NULL,
  `Qty` int(11) DEFAULT NULL,
  `Total` double DEFAULT NULL,
  `Profit` double DEFAULT NULL,
  `VNo` int(11) DEFAULT NULL,
  `Date` date DEFAULT NULL,
  `Cashier` varchar(50) DEFAULT NULL,
  `Refer` varchar(250) DEFAULT NULL,
  `cost_price` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table: tbl_sale_draft
DROP TABLE IF EXISTS `tbl_sale_draft`;
CREATE TABLE `tbl_sale_draft` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cat_id` text DEFAULT NULL,
  `Barcode` varchar(50) DEFAULT NULL,
  `Name` text DEFAULT NULL,
  `SaleType` varchar(50) DEFAULT NULL,
  `SalePrice` double DEFAULT NULL,
  `dis` double DEFAULT NULL,
  `Qty` int(11) DEFAULT NULL,
  `Total` double DEFAULT NULL,
  `Profit` double DEFAULT NULL,
  `VNo` int(11) DEFAULT NULL,
  `Date` date DEFAULT NULL,
  `Cashier` varchar(50) DEFAULT NULL,
  `Refer` varchar(250) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table: tbl_sale_draft_no
DROP TABLE IF EXISTS `tbl_sale_draft_no`;
CREATE TABLE `tbl_sale_draft_no` (
  `id` int(11) NOT NULL,
  `user_name` varchar(50) DEFAULT NULL,
  `sub_total` double DEFAULT NULL,
  `actual_cost` double NOT NULL,
  `dis` double DEFAULT NULL,
  `tax` double DEFAULT NULL,
  `customer_name` varchar(50) DEFAULT NULL,
  `Date` datetime DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  `payment` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table: tbl_sale_package
DROP TABLE IF EXISTS `tbl_sale_package`;
CREATE TABLE `tbl_sale_package` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cat_id` text DEFAULT NULL,
  `Barcode` varchar(50) DEFAULT NULL,
  `Name` text DEFAULT NULL,
  `SaleType` varchar(50) DEFAULT NULL,
  `SalePrice` double DEFAULT NULL,
  `dis` double DEFAULT NULL,
  `Qty` int(11) DEFAULT NULL,
  `Total` double DEFAULT NULL,
  `Profit` double DEFAULT NULL,
  `VNo` int(11) DEFAULT NULL,
  `Date` date DEFAULT NULL,
  `Cashier` varchar(50) DEFAULT NULL,
  `Refer` varchar(250) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table: tbl_sale_package_no
DROP TABLE IF EXISTS `tbl_sale_package_no`;
CREATE TABLE `tbl_sale_package_no` (
  `id` int(11) NOT NULL,
  `user_name` varchar(50) DEFAULT NULL,
  `sub_total` double DEFAULT NULL,
  `actual_cost` double NOT NULL,
  `dis` double DEFAULT NULL,
  `tax` double DEFAULT NULL,
  `customer_name` varchar(50) DEFAULT NULL,
  `Date` datetime DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  `payment` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table: tbl_sale_return
DROP TABLE IF EXISTS `tbl_sale_return`;
CREATE TABLE `tbl_sale_return` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cat_id` text DEFAULT NULL,
  `barcode` varchar(50) DEFAULT NULL,
  `name` varchar(50) DEFAULT NULL,
  `sale_price` double DEFAULT NULL,
  `qty` int(11) DEFAULT NULL,
  `total` double DEFAULT NULL,
  `profit` double DEFAULT NULL,
  `remark` varchar(50) DEFAULT NULL,
  `date` date DEFAULT NULL,
  `voucher_return_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table: tbl_sale_return_item
DROP TABLE IF EXISTS `tbl_sale_return_item`;
CREATE TABLE `tbl_sale_return_item` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cat_id` text DEFAULT NULL,
  `barcode` varchar(50) DEFAULT NULL,
  `name` varchar(50) DEFAULT NULL,
  `sale_price` double DEFAULT NULL,
  `qty` int(11) DEFAULT NULL,
  `total` double DEFAULT NULL,
  `profit` double DEFAULT NULL,
  `remark` varchar(50) DEFAULT NULL,
  `date` date DEFAULT NULL,
  `vno` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table: tbl_service
DROP TABLE IF EXISTS `tbl_service`;
CREATE TABLE `tbl_service` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `barcode` varchar(50) NOT NULL,
  `service_name` varchar(50) NOT NULL,
  `cat_id` varchar(50) NOT NULL,
  `buy_price` int(11) NOT NULL,
  `sale_price` int(11) NOT NULL,
  `remark` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table: tbl_service_catalog
DROP TABLE IF EXISTS `tbl_service_catalog`;
CREATE TABLE `tbl_service_catalog` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data for table: tbl_service_catalog
INSERT INTO `tbl_service_catalog` (`id`, `name`) VALUES
(1, 'Consultation'),
(2, 'Laboratory'),
(3, 'X-Ray'),
(4, 'Ultrasound'),
(5, 'ECG'),
(6, 'Vaccination');

-- Table: tbl_shopinfo
DROP TABLE IF EXISTS `tbl_shopinfo`;
CREATE TABLE `tbl_shopinfo` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) DEFAULT NULL,
  `type` varchar(50) DEFAULT NULL,
  `ph_no` varchar(50) DEFAULT NULL,
  `email` varchar(250) DEFAULT NULL,
  `address` varchar(500) DEFAULT NULL,
  `remark` varchar(250) DEFAULT NULL,
  `thanks` varchar(250) DEFAULT NULL,
  `photo` longblob DEFAULT NULL,
  `photo_path` varchar(255) DEFAULT NULL,
  `user_code` varchar(250) DEFAULT NULL,
  `product_code` varchar(250) DEFAULT NULL,
  `software_code` varchar(250) DEFAULT NULL,
  `printer_voucher_count` int(11) DEFAULT NULL,
  `printer` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data for table: tbl_shopinfo
INSERT INTO `tbl_shopinfo` (`id`, `name`, `type`, `ph_no`, `email`, `address`, `remark`, `thanks`, `photo`, `photo_path`, `user_code`, `product_code`, `software_code`, `printer_voucher_count`, `printer`) VALUES
(1, 'Clinic Pro Medical Center', 'Clinic & Pharmacy', '09-999999999', 'info@clinicpro.com', 'No. 123, Main Street, Yangon', 'Open 24/7', 'Thank you for choosing Clinic Pro! Stay healthy!', NULL, NULL, NULL, NULL, NULL, NULL, '80mm');

-- Table: tbl_stock
DROP TABLE IF EXISTS `tbl_stock`;
CREATE TABLE `tbl_stock` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cat_id` varchar(255) DEFAULT NULL,
  `cat_id_2` varchar(50) DEFAULT NULL,
  `barcode` varchar(50) DEFAULT NULL,
  `name` text DEFAULT NULL,
  `qty` int(11) DEFAULT NULL,
  `qty_alert` int(11) DEFAULT NULL,
  `unit_name` varchar(50) DEFAULT NULL,
  `cost_price` int(11) DEFAULT NULL,
  `sale_price_latli` int(11) DEFAULT NULL,
  `sale_price_latkar` int(11) DEFAULT NULL,
  `remark` varchar(255) DEFAULT NULL,
  `expire_date` date DEFAULT NULL,
  `alert_month` int(11) DEFAULT NULL,
  `alert_date` date DEFAULT NULL,
  `margin` double DEFAULT NULL,
  `image_path` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_stock_barcode` (`barcode`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data for table: tbl_stock
INSERT INTO `tbl_stock` (`id`, `cat_id`, `cat_id_2`, `barcode`, `name`, `qty`, `qty_alert`, `unit_name`, `cost_price`, `sale_price_latli`, `sale_price_latkar`, `remark`, `expire_date`, `alert_month`, `alert_date`, `margin`, `image_path`) VALUES
(1, '1', NULL, '8850987180001', 'Paracetamol 500mg', 1000, 50, 'Tablet', 50, 100, 90, 'For fever and pain', NULL, NULL, NULL, NULL, NULL),
(2, '1', NULL, '8850987180002', 'Amoxicillin 500mg', 500, 30, 'Capsule', 200, 350, 300, 'Antibiotic', NULL, NULL, NULL, NULL, NULL),
(3, '1', NULL, '8850987180003', 'Vitamin C 1000mg', 800, 40, 'Tablet', 100, 200, 180, 'Immune support', NULL, NULL, NULL, NULL, NULL);

-- Table: tbl_stock_expense
DROP TABLE IF EXISTS `tbl_stock_expense`;
CREATE TABLE `tbl_stock_expense` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_name` varchar(50) DEFAULT NULL,
  `cat_id` text DEFAULT NULL,
  `barcode` varchar(50) DEFAULT NULL,
  `name` varchar(250) DEFAULT NULL,
  `qty` int(11) DEFAULT NULL,
  `unit` varchar(50) DEFAULT NULL,
  `cost_price` double DEFAULT NULL,
  `total_cost` double DEFAULT NULL,
  `reason` varchar(250) DEFAULT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table: tbl_supplier
DROP TABLE IF EXISTS `tbl_supplier`;
CREATE TABLE `tbl_supplier` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) DEFAULT NULL,
  `ph_no` varchar(50) DEFAULT NULL,
  `nrc_no` varchar(50) DEFAULT NULL,
  `shop` text DEFAULT NULL,
  `address` text DEFAULT NULL,
  `date` date DEFAULT NULL,
  `remark` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data for table: tbl_supplier
INSERT INTO `tbl_supplier` (`id`, `name`, `ph_no`, `nrc_no`, `shop`, `address`, `date`, `remark`) VALUES
(1, 'Myanmar Pharma Co.', '01-234567', '12/YGNXXX', 'Myanmar Pharma Headquarters', 'Industrial Zone, Yangon', '2025-10-12 00:00:00', 'Main pharmaceutical supplier'),
(2, 'Asia Med Import', '01-345678', '12/YGNXXX', 'Asia Med Trading', 'Bo Aung Kyaw Street, Yangon', '2025-10-12 00:00:00', 'Import medicines'),
(3, 'Global Health Supplies', '01-456789', '12/YGNXXX', 'Global Health Office', 'Downtown, Yangon', '2025-10-12 00:00:00', 'International supplier'),
(4, 'Local Medical Store', '01-567890', '12/YGNXXX', 'Local Medical Warehouse', 'Tharketa, Yangon', '2025-10-12 00:00:00', 'Local distributor'),
(5, 'Wellcare Distribution', '01-678901', '12/YGNXXX', 'Wellcare HQ', 'Mayangone, Yangon', '2025-10-12 00:00:00', 'National distributor'),
(6, 'HealthPlus Trading', '01-789012', '12/YGNXXX', 'HealthPlus Office', 'Sanchaung, Yangon', '2025-10-12 00:00:00', 'Medical equipment'),
(7, 'MedSupply Myanmar', '01-890123', '12/YGNXXX', 'MedSupply Center', 'Insein, Yangon', '2025-10-12 00:00:00', 'Bulk supplier'),
(8, 'PharmaLink Co.', '01-901234', '12/YGNXXX', 'PharmaLink Branch', 'Bahan, Yangon', '2025-10-12 00:00:00', 'Generic medicines'),
(9, 'CareFirst Suppliers', '01-012345', '12/YGNXXX', 'CareFirst Depot', 'Hlaing, Yangon', '2025-10-12 00:00:00', 'Fast delivery'),
(10, 'Unity Medical Trading', '01-123456', '12/YGNXXX', 'Unity Medical Office', 'Pazundaung, Yangon', '2025-10-12 00:00:00', 'Competitive prices');

-- Table: tbl_supplier_debt
DROP TABLE IF EXISTS `tbl_supplier_debt`;
CREATE TABLE `tbl_supplier_debt` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `supplier_id` int(11) NOT NULL,
  `voucher_id` int(11) DEFAULT NULL,
  `debt` double DEFAULT NULL,
  `pay` double DEFAULT NULL,
  `remark` text DEFAULT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table: tbl_township
DROP TABLE IF EXISTS `tbl_township`;
CREATE TABLE `tbl_township` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `state` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table: tbl_treatment
DROP TABLE IF EXISTS `tbl_treatment`;
CREATE TABLE `tbl_treatment` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` varchar(50) DEFAULT NULL,
  `doctor_id` int(11) DEFAULT NULL,
  `chief_complaint` text DEFAULT NULL,
  `present_illness` text DEFAULT NULL,
  `Past_Diagnoses` text DEFAULT NULL,
  `Surgeries_Procedures` text DEFAULT NULL,
  `Hospitalizations` text DEFAULT NULL,
  `Current_Medications` text DEFAULT NULL,
  `Dosages` text DEFAULT NULL,
  `Allergen` text DEFAULT NULL,
  `Treatment_Type` text DEFAULT NULL,
  `diagnosis` text DEFAULT NULL,
  `prescription` text DEFAULT NULL,
  `Date` date DEFAULT NULL,
  `Voucher_id` varchar(50) DEFAULT NULL,
  `Recommendation` text DEFAULT NULL,
  `vital_signs` text DEFAULT NULL,
  `notes` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_treatment_patient` (`patient_id`)
) ENGINE=InnoDB AUTO_INCREMENT=56 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data for table: tbl_treatment
INSERT INTO `tbl_treatment` (`id`, `patient_id`, `doctor_id`, `chief_complaint`, `present_illness`, `Past_Diagnoses`, `Surgeries_Procedures`, `Hospitalizations`, `Current_Medications`, `Dosages`, `Allergen`, `Treatment_Type`, `diagnosis`, `prescription`, `Date`, `Voucher_id`, `Recommendation`, `vital_signs`, `notes`) VALUES
(1, 'OPD-001', NULL, NULL, NULL, 'Seasonal Allergies', 'None', 'None', 'Paracetamol, Vitamin C', '500mg TID, 1000mg OD', 'None Known', 'Outpatient', NULL, NULL, '2025-10-12 00:00:00', 'V-1001', 'Rest, plenty of fluids, avoid cold exposure', NULL, NULL),
(2, 'OPD-002', NULL, NULL, NULL, 'Hypertension (5 years)', 'None', 'None', 'Amlodipine, Losartan', '5mg OD, 50mg OD', 'None Known', 'Outpatient', NULL, NULL, '2025-10-12 00:00:00', 'V-1002', 'Continue medications, low salt diet, regular exercise', NULL, NULL),
(3, 'OPD-003', NULL, NULL, NULL, 'Diabetes Type 2 (10 years)', 'None', 'None', 'Metformin, Glimepiride', '500mg BD, 2mg OD', 'Sulfa drugs', 'Outpatient', NULL, NULL, '2025-10-12 00:00:00', 'V-1003', 'Monitor blood sugar daily, diabetic diet, foot care', NULL, NULL),
(4, 'OPD-004', NULL, NULL, NULL, 'Chronic Back Pain', 'None', 'None', 'Ibuprofen, Muscle Relaxant', '400mg TID, 1 tab BD', 'None Known', 'Outpatient', NULL, NULL, '2025-10-12 00:00:00', 'V-1004', 'Physiotherapy 3x/week, avoid heavy lifting', NULL, NULL),
(5, 'OPD-005', NULL, NULL, NULL, 'Gastritis (2 years)', 'None', 'None', 'Omeprazole, Antacid', '20mg BD, PRN', 'Penicillin', 'Outpatient', NULL, NULL, '2025-10-12 00:00:00', 'V-1005', 'Avoid spicy food, eat small meals, reduce stress', NULL, NULL),
(6, 'OPD-006', NULL, NULL, NULL, 'Migraine (Chronic)', 'None', 'None', 'Sumatriptan, Propranolol', '50mg PRN, 40mg BD', 'Aspirin', 'Outpatient', NULL, NULL, '2025-10-12 00:00:00', 'V-1006', 'Avoid triggers, stress management, adequate sleep', NULL, NULL),
(7, 'OPD-007', NULL, NULL, NULL, 'Osteoarthritis', 'None', 'None', 'Diclofenac, Glucosamine', '75mg BD, 500mg OD', 'None Known', 'Outpatient', NULL, NULL, '2025-10-12 00:00:00', 'V-1007', 'Weight management, gentle exercises, heat therapy', NULL, NULL),
(8, 'OPD-008', NULL, NULL, NULL, 'Bronchial Asthma', 'None', 'None', 'Salbutamol Inhaler, Budesonide', '2 puffs PRN, 200mcg BD', 'Pollen', 'Outpatient', NULL, NULL, '2025-10-12 00:00:00', 'V-1008', 'Avoid allergens, proper inhaler technique', NULL, NULL),
(9, 'OPD-009', NULL, NULL, NULL, 'Atopic Dermatitis', 'None', 'None', 'Cetirizine, Hydrocortisone Cream', '10mg OD, Apply BD', 'Latex', 'Outpatient', NULL, NULL, '2025-10-12 00:00:00', 'V-1009', 'Moisturize skin, avoid irritants', NULL, NULL),
(10, 'OPD-010', NULL, NULL, NULL, 'Viral Fever', 'None', 'None', 'Paracetamol, Antihistamine', '500mg TID, 1 tab HS', 'None Known', 'Outpatient', NULL, NULL, '2025-10-12 00:00:00', 'V-1010', 'Rest, hydration, symptomatic treatment', NULL, NULL),
(11, 'OPD-011', NULL, NULL, NULL, 'Hyperlipidemia', 'None', 'None', 'Atorvastatin, Omega-3', '20mg OD, 1000mg OD', 'None Known', 'Outpatient', NULL, NULL, '2025-10-12 00:00:00', 'V-1011', 'Low fat diet, regular exercise, follow-up in 3 months', NULL, NULL),
(12, 'OPD-012', NULL, NULL, NULL, 'Hypothyroidism', 'None', 'None', 'Levothyroxine', '100mcg OD (morning)', 'None Known', 'Outpatient', NULL, NULL, '2025-10-12 00:00:00', 'V-1012', 'Take on empty stomach, thyroid function test in 6 weeks', NULL, NULL),
(13, 'OPD-013', NULL, NULL, NULL, 'Ankle Sprain', 'None', 'None', 'Diclofenac, Ice therapy', '75mg BD, Apply 4x/day', 'None Known', 'Outpatient', NULL, NULL, '2025-10-12 00:00:00', 'V-1013', 'RICE protocol, avoid weight bearing, follow-up in 1 week', NULL, NULL),
(14, 'OPD-014', NULL, NULL, NULL, 'Prenatal Care - 24 weeks', 'None', 'None', 'Folic Acid, Iron, Calcium', '5mg OD, 60mg OD, 500mg BD', 'None Known', 'Outpatient', NULL, NULL, '2025-10-12 00:00:00', 'V-1014', 'Regular antenatal checkups, balanced diet, adequate rest', NULL, NULL),
(15, 'OPD-015', NULL, NULL, NULL, 'Coronary Artery Disease', 'CABG 2 years ago', 'Cardiac ICU admission post-CABG', 'Aspirin, Clopidogrel, Metoprolol, Rosuvastatin', '100mg OD, 75mg OD, 50mg BD, 20mg OD', 'NSAIDs', 'Outpatient', NULL, NULL, '2025-10-12 00:00:00', 'V-1015', 'Cardiac rehab, stress test in 3 months, low cholesterol diet', NULL, NULL),
(16, 'IPD-001', NULL, NULL, NULL, 'Pneumonia', 'None', 'Previous pneumonia 3 years ago', 'Ceftriaxone IV, Azithromycin', '1g BD IV, 500mg OD', 'None Known', 'Inpatient', NULL, NULL, '2025-10-09 00:00:00', 'V-2001', 'Complete antibiotic course, chest physiotherapy', NULL, NULL),
(17, 'IPD-002', NULL, NULL, NULL, 'Appendicitis', 'Appendectomy', 'Current admission', 'Cefuroxime IV, Metronidazole', '750mg TID IV, 500mg TID', 'None Known', 'Inpatient', NULL, NULL, '2025-10-07 00:00:00', 'V-2002', 'Post-op care, gradual diet advancement', NULL, NULL),
(18, 'IPD-003', NULL, NULL, NULL, 'Dengue Fever', 'None', 'None', 'IV Fluids, Paracetamol', 'Maintenance, 500mg TID', 'None Known', 'Inpatient', NULL, NULL, '2025-10-10 00:00:00', 'V-2003', 'Monitor platelet count, adequate hydration', NULL, NULL),
(19, 'IPD-004', NULL, NULL, NULL, 'Pregnancy - Term', 'C-Section Delivery', 'Current admission', 'Cefazolin, Oxytocin', '1g IV, As needed', 'None Known', 'Inpatient', NULL, NULL, '2025-10-11 00:00:00', 'V-2004', 'Post-operative care, breastfeeding support', NULL, NULL),
(20, 'IPD-005', NULL, NULL, NULL, 'Ischemic Stroke', 'None', 'Current admission', 'Aspirin, Atorvastatin, Clopidogrel', '100mg OD, 40mg OD, 75mg OD', 'None Known', 'Inpatient', NULL, NULL, '2025-10-05 00:00:00', 'V-2005', 'Physiotherapy, speech therapy, blood pressure control', NULL, NULL),
(21, 'IPD-006', NULL, NULL, NULL, 'Nephrolithiasis', 'None', 'None', 'IV Fluids, Ketorolac, Tamsulosin', 'Maintenance, 30mg IM PRN, 0.4mg OD', 'None Known', 'Inpatient', NULL, NULL, '2025-10-11 00:00:00', 'V-2006', 'Hydration, pain management, lithotripsy scheduled', NULL, NULL),
(22, 'IPD-007', NULL, NULL, NULL, 'Multiple Fractures', 'ORIF Left Femur', 'Current admission', 'Cefazolin IV, Tramadol', '1g TID IV, 50mg QID', 'Morphine', 'Inpatient', NULL, NULL, '2025-10-08 00:00:00', 'V-2007', 'Bed rest, wound care, physiotherapy after 2 weeks', NULL, NULL),
(23, 'IPD-008', NULL, NULL, NULL, 'Severe Dehydration', 'None', 'None', 'IV Ringer Lactate, Ondansetron', '2L over 4hrs, 4mg TID', 'None Known', 'Inpatient', NULL, NULL, '2025-10-12 00:00:00', 'V-2008', 'Oral rehydration when tolerated, monitor electrolytes', NULL, NULL),
(24, 'IPD-009', NULL, NULL, NULL, 'Peptic Ulcer Disease', 'None', 'Previous GI bleed 1 year ago', 'Pantoprazole IV, Sucralfate', '40mg BD IV, 1g QID', 'NSAIDs', 'Inpatient', NULL, NULL, '2025-10-10 00:00:00', 'V-2009', 'H. pylori testing, endoscopy scheduled, avoid NSAIDs', NULL, NULL),
(25, 'IPD-010', NULL, NULL, NULL, 'Acute Cholecystitis', 'Laparoscopic Cholecystectomy', 'Current admission', 'Ceftriaxone IV, Metronidazole IV', '1g BD IV, 500mg TID IV', 'None Known', 'Inpatient', NULL, NULL, '2025-10-09 00:00:00', 'V-2010', 'Post-op recovery, low fat diet after discharge', NULL, NULL),
(26, 'OPD-001', NULL, NULL, NULL, 'URI resolved, mild cough persists', 'None', 'None', 'Dextromethorphan Syrup', '10ml TID', 'None Known', 'Follow-up', NULL, NULL, '2025-10-09 00:00:00', 'V-1011', 'Complete cough syrup, return if fever develops', NULL, NULL),
(27, 'OPD-002', NULL, NULL, NULL, 'BP controlled, no complications', 'None', 'None', 'Amlodipine, Losartan', '5mg OD, 50mg OD', 'None Known', 'Follow-up', NULL, NULL, '2025-10-05 00:00:00', 'V-1012', 'Continue current medications, BP monitoring at home', NULL, NULL),
(28, 'OPD-003', NULL, NULL, NULL, 'HbA1c improved to 7.2%', 'None', 'None', 'Metformin, Glimepiride, Insulin Glargine', '500mg BD, 2mg OD, 10 units HS', 'Sulfa drugs', 'Follow-up', NULL, NULL, '2025-09-28 00:00:00', 'V-1013', 'Good control, continue regimen, next HbA1c in 3 months', NULL, NULL),
(29, 'OPD-006', NULL, NULL, NULL, 'Migraine frequency reduced', 'None', 'None', 'Propranolol, Magnesium', '40mg BD, 400mg OD', 'Aspirin', 'Follow-up', NULL, NULL, '2025-10-02 00:00:00', 'V-1014', 'Maintain stress diary, continue prophylaxis', NULL, NULL),
(30, 'OPD-007', NULL, NULL, NULL, 'Joint pain improved', 'None', 'None', 'Diclofenac, Glucosamine, Physiotherapy', '75mg BD, 500mg OD, 3x/week', 'None Known', 'Follow-up', NULL, NULL, '2025-10-07 00:00:00', 'V-1015', 'Continue therapy, consider intra-articular injection', NULL, NULL),
(31, 'OPD-001', NULL, NULL, NULL, 'Common Cold - New episode', 'None', 'None', 'Paracetamol, Cetirizine, Vitamin C', '500mg TID, 10mg OD, 1000mg OD', 'None Known', 'Outpatient', NULL, NULL, '2025-09-12 00:00:00', 'V-1016', 'Symptomatic treatment, adequate rest', NULL, NULL),
(32, 'OPD-002', NULL, NULL, NULL, 'Hypertension - Routine checkup', 'None', 'None', 'Amlodipine, Losartan, Aspirin', '5mg OD, 50mg OD, 100mg OD', 'None Known', 'Follow-up', NULL, NULL, '2025-08-13 00:00:00', 'V-1017', 'BP well controlled, continue medications', NULL, NULL),
(33, 'OPD-011', NULL, NULL, NULL, 'Lipid panel improved', 'None', 'None', 'Atorvastatin, Omega-3, Fenofibrate', '20mg OD, 1000mg OD, 145mg OD', 'None Known', 'Follow-up', NULL, NULL, '2025-07-14 00:00:00', 'V-1018', 'Excellent response, maintain lifestyle changes', NULL, NULL),
(34, 'OPD-012', NULL, NULL, NULL, 'TSH normalized', 'None', 'None', 'Levothyroxine', '100mcg OD', 'None Known', 'Follow-up', NULL, NULL, '2025-08-31 00:00:00', 'V-1019', 'Optimal dose achieved, annual monitoring', NULL, NULL),
(35, 'OPD-015', NULL, NULL, NULL, 'Stable angina', 'CABG 2 years ago', 'Cardiac ICU admission post-CABG', 'Aspirin, Clopidogrel, Metoprolol, Rosuvastatin, Isosorbide', '100mg OD, 75mg OD, 50mg BD, 20mg OD, 5mg BD', 'NSAIDs', 'Follow-up', NULL, NULL, '2025-09-21 00:00:00', 'V-1020', 'Exercise tolerance improved, continue cardiac rehab', NULL, NULL),
(36, 'OPD-013', NULL, NULL, NULL, 'Ankle fully healed', 'None', 'None', 'Stopped medications', 'None', 'None Known', 'Follow-up', NULL, NULL, '2025-09-28 00:00:00', 'V-1021', 'Gradual return to activities, strengthening exercises', NULL, NULL),
(37, 'OPD-014', NULL, NULL, NULL, 'Normal pregnancy progression - 28 weeks', 'None', 'None', 'Folic Acid, Iron, Calcium, Vitamin D', '5mg OD, 60mg OD, 500mg BD, 1000 IU OD', 'None Known', 'Follow-up', NULL, NULL, '2025-09-14 00:00:00', 'V-1022', 'Ultrasound scheduled, glucose tolerance test done', NULL, NULL),
(38, 'OPD-008', NULL, NULL, NULL, 'Asthma well controlled', 'None', 'None', 'Salbutamol Inhaler, Budesonide', '2 puffs PRN, 200mcg BD', 'Pollen', 'Follow-up', NULL, NULL, '2025-09-27 00:00:00', 'V-1023', 'Peak flow monitoring, continue preventer', NULL, NULL),
(39, 'OPD-009', NULL, NULL, NULL, 'Eczema improved', 'None', 'None', 'Cetirizine, Hydrocortisone Cream', '10mg OD, Apply BD', 'Latex', 'Follow-up', NULL, NULL, '2025-10-05 00:00:00', 'V-1024', 'Taper steroid cream, emollient use', NULL, NULL),
(40, 'OPD-004', NULL, NULL, NULL, 'Back pain recurrence', 'None', 'None', 'Diclofenac, Muscle Relaxant, Physiotherapy', '75mg BD, 1 tab TID, Daily sessions', 'None Known', 'Outpatient', NULL, NULL, '2025-09-22 00:00:00', 'V-1025', 'MRI scheduled, core strengthening exercises', NULL, NULL),
(41, 'IPD-001', NULL, NULL, NULL, 'Pneumonia', 'None', 'Previous pneumonia 3 years ago', 'Ceftriaxone IV, Azithromycin', '1g BD IV, 500mg OD', 'None Known', 'Inpatient', NULL, NULL, '2025-10-09 00:00:00', 'V-2001', 'Complete antibiotic course, chest physiotherapy', NULL, NULL),
(42, 'IPD-002', NULL, NULL, NULL, 'Appendicitis', 'Appendectomy', 'Current admission', 'Cefuroxime IV, Metronidazole', '750mg TID IV, 500mg TID', 'None Known', 'Inpatient', NULL, NULL, '2025-10-07 00:00:00', 'V-2002', 'Post-op care, gradual diet advancement', NULL, NULL),
(43, 'IPD-003', NULL, NULL, NULL, 'Dengue Fever', 'None', 'None', 'IV Fluids, Paracetamol', 'Maintenance, 500mg TID', 'None Known', 'Inpatient', NULL, NULL, '2025-10-10 00:00:00', 'V-2003', 'Monitor platelet count, adequate hydration', NULL, NULL),
(44, 'IPD-004', NULL, NULL, NULL, 'Pregnancy - Term', 'C-Section Delivery', 'Current admission', 'Cefazolin, Oxytocin', '1g IV, As needed', 'None Known', 'Inpatient', NULL, NULL, '2025-10-11 00:00:00', 'V-2004', 'Post-operative care, breastfeeding support', NULL, NULL),
(45, 'IPD-005', NULL, NULL, NULL, 'Ischemic Stroke', 'None', 'Current admission', 'Aspirin, Atorvastatin, Clopidogrel', '100mg OD, 40mg OD, 75mg OD', 'None Known', 'Inpatient', NULL, NULL, '2025-10-05 00:00:00', 'V-2005', 'Physiotherapy, speech therapy, blood pressure control', NULL, NULL),
(46, 'IPD-006', NULL, NULL, NULL, 'Nephrolithiasis', 'None', 'None', 'IV Fluids, Ketorolac, Tamsulosin', 'Maintenance, 30mg IM PRN, 0.4mg OD', 'None Known', 'Inpatient', NULL, NULL, '2025-10-11 00:00:00', 'V-2006', 'Hydration, pain management, lithotripsy scheduled', NULL, NULL),
(47, 'IPD-007', NULL, NULL, NULL, 'Multiple Fractures', 'ORIF Left Femur', 'Current admission', 'Cefazolin IV, Tramadol', '1g TID IV, 50mg QID', 'Morphine', 'Inpatient', NULL, NULL, '2025-10-08 00:00:00', 'V-2007', 'Bed rest, wound care, physiotherapy after 2 weeks', NULL, NULL),
(48, 'IPD-008', NULL, NULL, NULL, 'Severe Dehydration', 'None', 'None', 'IV Ringer Lactate, Ondansetron', '2L over 4hrs, 4mg TID', 'None Known', 'Inpatient', NULL, NULL, '2025-10-12 00:00:00', 'V-2008', 'Oral rehydration when tolerated, monitor electrolytes', NULL, NULL),
(49, 'IPD-009', NULL, NULL, NULL, 'Peptic Ulcer Disease', 'None', 'Previous GI bleed 1 year ago', 'Pantoprazole IV, Sucralfate', '40mg BD IV, 1g QID', 'NSAIDs', 'Inpatient', NULL, NULL, '2025-10-10 00:00:00', 'V-2009', 'H. pylori testing, endoscopy scheduled, avoid NSAIDs', NULL, NULL),
(50, 'IPD-010', NULL, NULL, NULL, 'Acute Cholecystitis', 'Laparoscopic Cholecystectomy', 'Current admission', 'Ceftriaxone IV, Metronidazole IV', '1g BD IV, 500mg TID IV', 'None Known', 'Inpatient', NULL, NULL, '2025-10-09 00:00:00', 'V-2010', 'Post-op recovery, low fat diet after discharge', NULL, NULL),
(51, 'IPD-001', NULL, NULL, NULL, 'Pneumonia resolving', 'None', 'Current admission', 'Oral Amoxicillin, Bromhexine', '500mg TID, 8mg TID', 'None Known', 'Inpatient', NULL, NULL, '2025-10-11 00:00:00', 'V-2011', 'Ready for discharge tomorrow, complete oral antibiotics', NULL, NULL),
(52, 'IPD-003', NULL, NULL, NULL, 'Dengue - Platelets recovering', 'None', 'Current admission', 'IV Fluids, Paracetamol', 'Maintenance, 500mg TID', 'None Known', 'Inpatient', NULL, NULL, '2025-10-12 00:00:00', 'V-2012', 'Platelets 95k, continue monitoring, discharge in 2 days', NULL, NULL),
(53, 'IPD-005', NULL, NULL, NULL, 'Stroke - Rehabilitation progress', 'None', 'Current admission', 'Aspirin, Atorvastatin, Clopidogrel, Physiotherapy', '100mg OD, 40mg OD, 75mg OD, BD sessions', 'None Known', 'Inpatient', NULL, NULL, '2025-10-09 00:00:00', 'V-2013', 'Motor function improving, continue intensive rehab', NULL, NULL),
(54, 'IPD-007', NULL, NULL, NULL, 'Fracture healing well', 'ORIF Left Femur', 'Current admission', 'Oral Cefuroxime, Tramadol', '500mg BD, 50mg QID', 'Morphine', 'Inpatient', NULL, NULL, '2025-10-11 00:00:00', 'V-2014', 'X-ray shows good alignment, start partial weight bearing', NULL, NULL),
(55, 'IPD-010', NULL, NULL, NULL, 'Post-cholecystectomy recovery', 'Laparoscopic Cholecystectomy', 'Current admission', 'Oral Cefuroxime, Paracetamol', '500mg BD, 500mg TID', 'None Known', 'Inpatient', NULL, NULL, '2025-10-11 00:00:00', 'V-2015', 'Wound healing well, tolerating diet, discharge tomorrow', NULL, NULL);

-- Table: tbl_unit
DROP TABLE IF EXISTS `tbl_unit`;
CREATE TABLE `tbl_unit` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `unit_name` varchar(50) DEFAULT NULL,
  `remark` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data for table: tbl_unit
INSERT INTO `tbl_unit` (`id`, `unit_name`, `remark`) VALUES
(1, 'Tablet', 'Per tablet'),
(2, 'Box', 'Per box'),
(3, 'Bottle', 'Per bottle'),
(4, 'Vial', 'Per vial'),
(5, 'Pack', 'Per pack'),
(6, 'Piece', 'Per piece');

-- Table: tbl_user
DROP TABLE IF EXISTS `tbl_user`;
CREATE TABLE `tbl_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `role_id` varchar(100) NOT NULL,
  `name` varchar(100) DEFAULT NULL,
  `passwd` varchar(100) DEFAULT NULL,
  `ph_no` varchar(50) DEFAULT NULL,
  `nrc_no` varchar(50) DEFAULT NULL,
  `address` varchar(150) DEFAULT NULL,
  `photo` longblob DEFAULT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data for table: tbl_user
INSERT INTO `tbl_user` (`id`, `role_id`, `name`, `passwd`, `ph_no`, `nrc_no`, `address`, `photo`, `date`) VALUES
(1, '1', 'admin', '$2a$10$Ynx7owl45N.oXNS0gEr8JOVCDQbVuO6PKCaBiOlhteg2XaqyLqFkO', '09-123456789', '12/YGNXXX', 'Yangon', NULL, '2025-10-12 00:00:00');

-- Table: tbl_user_log
DROP TABLE IF EXISTS `tbl_user_log`;
CREATE TABLE `tbl_user_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_name` varchar(50) NOT NULL,
  `login_time` datetime DEFAULT NULL,
  `logout_time` datetime DEFAULT NULL,
  `total_sale` double DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data for table: tbl_user_log
INSERT INTO `tbl_user_log` (`id`, `user_name`, `login_time`, `logout_time`, `total_sale`) VALUES
(1, 'admin', '2025-10-12 23:46:57', NULL, NULL);

-- Table: tbl_voucher
DROP TABLE IF EXISTS `tbl_voucher`;
CREATE TABLE `tbl_voucher` (
  `id` int(11) NOT NULL,
  `user_name` varchar(50) DEFAULT NULL,
  `sub_total` double DEFAULT NULL,
  `actual_cost` double NOT NULL,
  `dis` double DEFAULT NULL,
  `tax` double DEFAULT NULL,
  `customer_name` varchar(50) DEFAULT NULL,
  `Date` datetime DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  `payment` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table: tbl_voucher_archive
DROP TABLE IF EXISTS `tbl_voucher_archive`;
CREATE TABLE `tbl_voucher_archive` (
  `id` int(11) NOT NULL,
  `user_name` varchar(50) DEFAULT NULL,
  `sub_total` double DEFAULT NULL,
  `actual_cost` double NOT NULL,
  `dis` double DEFAULT NULL,
  `tax` double DEFAULT NULL,
  `customer_name` varchar(50) DEFAULT NULL,
  `Date` datetime DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  `payment` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table: tbl_voucher_return
DROP TABLE IF EXISTS `tbl_voucher_return`;
CREATE TABLE `tbl_voucher_return` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_name` varchar(50) DEFAULT NULL,
  `sub_total` double DEFAULT NULL,
  `actual_cost` double NOT NULL,
  `dis` double DEFAULT NULL,
  `tax` double DEFAULT NULL,
  `customer_name` varchar(50) DEFAULT NULL,
  `Date` datetime DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  `payment` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

SET FOREIGN_KEY_CHECKS=1;
